/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.gbif.common.messaging.api.Message;
import org.gbif.common.messaging.api.MessageRegistry;
import org.gbif.common.messaging.api.messages.BackboneChangedMessage;
import org.gbif.common.messaging.api.messages.ChangeDoiMessage;
import org.gbif.common.messaging.api.messages.ChecklistAnalyzedMessage;
import org.gbif.common.messaging.api.messages.ChecklistNormalizedMessage;
import org.gbif.common.messaging.api.messages.ChecklistSyncedMessage;
import org.gbif.common.messaging.api.messages.CrawlErrorMessage;
import org.gbif.common.messaging.api.messages.CrawlFinishedMessage;
import org.gbif.common.messaging.api.messages.CrawlRequestMessage;
import org.gbif.common.messaging.api.messages.CrawlResponseMessage;
import org.gbif.common.messaging.api.messages.CrawlStartedMessage;
import org.gbif.common.messaging.api.messages.DeleteDataResourceOccurrencesMessage;
import org.gbif.common.messaging.api.messages.DeleteDatasetOccurrencesMessage;
import org.gbif.common.messaging.api.messages.DeleteOccurrenceMessage;
import org.gbif.common.messaging.api.messages.DwcaDownloadFinishedMessage;
import org.gbif.common.messaging.api.messages.DwcaMetasyncFinishedMessage;
import org.gbif.common.messaging.api.messages.DwcaValidationFinishedMessage;
import org.gbif.common.messaging.api.messages.FragmentPersistedMessage;
import org.gbif.common.messaging.api.messages.InterpretDatasetMessage;
import org.gbif.common.messaging.api.messages.InterpretVerbatimMessage;
import org.gbif.common.messaging.api.messages.MatchDatasetMessage;
import org.gbif.common.messaging.api.messages.OccurrenceFragmentedMessage;
import org.gbif.common.messaging.api.messages.OccurrenceMutatedMessage;
import org.gbif.common.messaging.api.messages.ParseDatasetMessage;
import org.gbif.common.messaging.api.messages.ParseFragmentMessage;
import org.gbif.common.messaging.api.messages.RegistryChangeMessage;
import org.gbif.common.messaging.api.messages.StartCrawlMessage;
import org.gbif.common.messaging.api.messages.StartMetasyncMessage;
import org.gbif.common.messaging.api.messages.VerbatimPersistedMessage;

@ThreadSafe
public class DefaultMessageRegistry
implements MessageRegistry {
    private final Object lock = new Object();
    private static final ImmutableMap<Class<? extends Message>, String> MESSAGE_TO_EXCHANGE_MAPPING = ImmutableMap.builder().put(CrawlErrorMessage.class, (Object)"crawler").put(CrawlFinishedMessage.class, (Object)"crawler").put(CrawlStartedMessage.class, (Object)"crawler").put(CrawlRequestMessage.class, (Object)"crawler").put(CrawlResponseMessage.class, (Object)"crawler").put(OccurrenceFragmentedMessage.class, (Object)"crawler").put(DwcaDownloadFinishedMessage.class, (Object)"crawler").put(DwcaMetasyncFinishedMessage.class, (Object)"crawler").put(DwcaValidationFinishedMessage.class, (Object)"crawler").put(FragmentPersistedMessage.class, (Object)"occurrence").put(VerbatimPersistedMessage.class, (Object)"occurrence").put(OccurrenceMutatedMessage.class, (Object)"occurrence").put(DeleteOccurrenceMessage.class, (Object)"occurrence").put(DeleteDataResourceOccurrencesMessage.class, (Object)"occurrence").put(DeleteDatasetOccurrencesMessage.class, (Object)"occurrence").put(ParseFragmentMessage.class, (Object)"occurrence").put(ParseDatasetMessage.class, (Object)"occurrence").put(InterpretVerbatimMessage.class, (Object)"occurrence").put(InterpretDatasetMessage.class, (Object)"occurrence").put(RegistryChangeMessage.class, (Object)"registry").put(StartCrawlMessage.class, (Object)"registry").put(StartMetasyncMessage.class, (Object)"registry").put(ChangeDoiMessage.class, (Object)"registry").put(ChecklistNormalizedMessage.class, (Object)"checklist").put(ChecklistSyncedMessage.class, (Object)"checklist").put(ChecklistAnalyzedMessage.class, (Object)"checklist").put(BackboneChangedMessage.class, (Object)"checklist").put(MatchDatasetMessage.class, (Object)"checklist").build();
    private static final ImmutableMap<Class<? extends Message>, String> MESSAGE_TO_ROUTING_KEY_MAPPING = ImmutableMap.builder().put(CrawlErrorMessage.class, (Object)"crawl.error").put(CrawlFinishedMessage.class, (Object)"crawl.finished").put(CrawlStartedMessage.class, (Object)"crawl.started").put(CrawlRequestMessage.class, (Object)"crawl.request").put(CrawlResponseMessage.class, (Object)"crawl.response").put(DwcaDownloadFinishedMessage.class, (Object)"crawl.dwca.download.finished").put(DwcaMetasyncFinishedMessage.class, (Object)"crawl.dwca.metasync.finished").put(DwcaValidationFinishedMessage.class, (Object)"crawl.dwca.validation.finished").put(OccurrenceFragmentedMessage.class, (Object)"crawler.fragment.new").put(FragmentPersistedMessage.class, (Object)"occurrence.fragment.persisted").put(VerbatimPersistedMessage.class, (Object)"occurrence.verbatim.persisted").put(OccurrenceMutatedMessage.class, (Object)"occurrence.interpreted.mutated").put(DeleteOccurrenceMessage.class, (Object)"occurrence.delete.occurrence").put(DeleteDataResourceOccurrencesMessage.class, (Object)"occurrence.delete.dataresource").put(DeleteDatasetOccurrencesMessage.class, (Object)"occurrence.delete.dataset").put(ParseFragmentMessage.class, (Object)"occurrence.parse.occurrence").put(ParseDatasetMessage.class, (Object)"occurrence.parse.dataset").put(InterpretVerbatimMessage.class, (Object)"occurrence.interpret.occurrence").put(InterpretDatasetMessage.class, (Object)"occurrence.interpret.dataset").put(RegistryChangeMessage.class, (Object)"registry.change.#").put(StartCrawlMessage.class, (Object)"crawl.start").put(StartMetasyncMessage.class, (Object)"metasync.start").put(ChecklistNormalizedMessage.class, (Object)"checklist.normalized").put(ChecklistSyncedMessage.class, (Object)"checklist.imported").put(ChecklistAnalyzedMessage.class, (Object)"checklist.analyzed").put(BackboneChangedMessage.class, (Object)"backbone.changed").put(ChangeDoiMessage.class, (Object)"doi.change").put(MatchDatasetMessage.class, (Object)"dataset.match").build();
    @GuardedBy(value="lock")
    private final ConcurrentMap<Class<? extends Message>, String> exchangeMapping = Maps.newConcurrentMap();
    @GuardedBy(value="lock")
    private final ConcurrentMap<Class<? extends Message>, String> routingKeyMapping = Maps.newConcurrentMap();

    public DefaultMessageRegistry() {
        this.exchangeMapping.putAll((Map<Class<? extends Message>, String>)MESSAGE_TO_EXCHANGE_MAPPING);
        this.routingKeyMapping.putAll((Map<Class<? extends Message>, String>)MESSAGE_TO_ROUTING_KEY_MAPPING);
    }

    @Override
    public Optional<String> getExchange(Class<? extends Message> message) {
        Preconditions.checkNotNull(message, (Object)"message can't be null");
        return Optional.fromNullable(this.exchangeMapping.get(message));
    }

    @Override
    public Optional<String> getGenericRoutingKey(Class<? extends Message> message) {
        Preconditions.checkNotNull(message, (Object)"message can't be null");
        return Optional.fromNullable(this.routingKeyMapping.get(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableSet<Class<? extends Message>> getRegisteredMessages() {
        Object object = this.lock;
        synchronized (object) {
            return ImmutableSet.copyOf(this.exchangeMapping.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Class<? extends Message> message, String exchange, String routingKey) {
        Preconditions.checkNotNull(message, (Object)"message can't be null");
        Preconditions.checkNotNull((Object)exchange, (Object)"exchange can't be null");
        Preconditions.checkNotNull((Object)routingKey, (Object)"routingKey can't be null");
        Object object = this.lock;
        synchronized (object) {
            this.exchangeMapping.put(message, exchange);
            this.routingKeyMapping.put(message, routingKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(Class<? extends Message> message) {
        Preconditions.checkNotNull(message, (Object)"message can't be null");
        Object object = this.lock;
        synchronized (object) {
            this.exchangeMapping.remove(message);
            this.routingKeyMapping.remove(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.exchangeMapping.clear();
            this.routingKeyMapping.clear();
        }
    }
}

