/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging;

import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.MessageProperties;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.concurrent.ThreadSafe;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.gbif.common.messaging.ConnectionParameters;
import org.gbif.common.messaging.DefaultMessageRegistry;
import org.gbif.common.messaging.api.Message;
import org.gbif.common.messaging.api.MessagePublisher;
import org.gbif.common.messaging.api.MessageRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultMessagePublisher
implements MessagePublisher,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMessagePublisher.class);
    private static final int NUMBER_OF_RETRIES = 3;
    private final Connection connection;
    private final MessageRegistry registry;
    private final ObjectMapper mapper;
    private final ConcurrentLinkedQueue<Channel> channelPool = Queues.newConcurrentLinkedQueue();

    public DefaultMessagePublisher(ConnectionParameters connectionParameters) throws IOException {
        this(connectionParameters, new DefaultMessageRegistry(), new ObjectMapper());
    }

    public DefaultMessagePublisher(ConnectionParameters connectionParameters, MessageRegistry registry, ObjectMapper mapper) throws IOException {
        Preconditions.checkNotNull((Object)connectionParameters, (Object)"connectionParameters can't be null");
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (Object)"mapper can't be null");
        this.registry = (MessageRegistry)Preconditions.checkNotNull((Object)registry, (Object)"registry can't be null");
        this.mapper.registerModule((Module)new GuavaModule());
        this.mapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        LOG.info("Connecting to AMQP broker {}", (Object)connectionParameters);
        this.connection = connectionParameters.getConnectionFactory().newConnection();
        this.declareAllExchanges(registry, this.connection);
    }

    @Override
    public void send(Message message) throws IOException {
        this.send(message, false);
    }

    @Override
    public void send(Message message, boolean persistent) throws IOException {
        Preconditions.checkNotNull((Object)message, (Object)"message can't be null");
        Optional<String> exchange = this.registry.getExchange(message.getClass());
        Preconditions.checkArgument((boolean)exchange.isPresent(), (Object)"No exchange found for Message");
        String routingKey = message.getRoutingKey();
        this.send(message, (String)exchange.get(), routingKey, persistent);
    }

    @Override
    public void send(Message message, String exchange) throws IOException {
        Preconditions.checkNotNull((Object)message, (Object)"message can't be null");
        Preconditions.checkNotNull((Object)exchange, (Object)"exchange can't be null");
        String routingKey = message.getRoutingKey();
        this.send(message, exchange, routingKey);
    }

    @Override
    public void send(Object message, String exchange, String routingKey) throws IOException {
        this.send(message, exchange, routingKey, false);
    }

    @Override
    public void send(Object message, String exchange, String routingKey, boolean persistent) throws IOException {
        Preconditions.checkNotNull((Object)message, (Object)"message can't be null");
        Preconditions.checkNotNull((Object)exchange, (Object)"exchange can't be null");
        Preconditions.checkNotNull((Object)routingKey, (Object)"routingKey can't be null");
        byte[] data = this.mapper.writeValueAsBytes(message);
        LOG.debug("Sending message of type [{}] to exchange [{}] using routing key [{}]", new Object[]{message.getClass().getSimpleName(), exchange, routingKey});
        for (int attempt = 1; attempt <= 3; ++attempt) {
            Channel channel = this.provideChannel();
            try {
                if (persistent) {
                    channel.basicPublish(exchange, routingKey, MessageProperties.PERSISTENT_TEXT_PLAIN, data);
                } else {
                    channel.basicPublish(exchange, routingKey, MessageProperties.TEXT_PLAIN, data);
                }
                this.releaseChannel(channel);
                return;
            }
            catch (IOException e) {
                if (attempt >= 3) {
                    LOG.warn("Tried sending message but failed {} times, aborting", (Object)attempt);
                    throw e;
                }
                LOG.debug("Failed sending message, retrying");
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void declareAllExchanges(MessageRegistry registry, Connection connection) throws IOException {
        try (Channel channel = null;){
            channel = connection.createChannel();
            for (Class message : registry.getRegisteredMessages()) {
                channel.exchangeDeclare((String)registry.getExchange(message).get(), "topic", true);
            }
        }
    }

    private Channel provideChannel() throws IOException {
        Channel channel = this.channelPool.poll();
        if (channel == null || !channel.isOpen()) {
            LOG.debug("No pooled channels available, creating a new one");
            channel = this.connection.createChannel();
        }
        return channel;
    }

    private void releaseChannel(Channel channel) {
        if (channel.isOpen()) {
            this.channelPool.add(channel);
            LOG.debug("Channel returned to the pool. Available channels for reuse: {}", (Object)this.channelPool.size());
        } else {
            LOG.debug("Discarding channel since it is closed. Available channels for reuse: {}", (Object)this.channelPool.size());
        }
    }

    @Override
    public void close() {
        for (Channel c : this.channelPool) {
            try {
                c.waitForConfirmsOrDie();
            }
            catch (IOException | InterruptedException e) {
                LOG.warn("Exception waiting for confirms", (Throwable)e);
            }
        }
        try {
            LOG.info("Closing connection to AMQP broker {}", (Object)this.connection);
            this.connection.close();
        }
        catch (IOException e) {
            LOG.error("Exception closing connection to AMQP broker", (Throwable)e);
        }
    }
}

