/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.rabbitmq.client.ConnectionFactory;

public class ConnectionParameters {
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String virtualHost;

    @Inject
    public ConnectionParameters(@Named(value="hostname") String host, @Named(value="port") int port, @Named(value="username") String username, @Named(value="password") String password, @Named(value="virtualhost") String virtualHost) {
        this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host can't be null");
        this.port = port;
        this.username = (String)Preconditions.checkNotNull((Object)username, (Object)"username can't be null");
        this.password = (String)Preconditions.checkNotNull((Object)password, (Object)"password can't be null");
        this.virtualHost = (String)Preconditions.checkNotNull((Object)virtualHost, (Object)"virtualHost can't be null");
        Preconditions.checkArgument((!host.isEmpty() ? 1 : 0) != 0, (Object)"host can't be empty");
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"port has to be greater than zero");
        Preconditions.checkArgument((!username.isEmpty() ? 1 : 0) != 0, (Object)"username can't be empty");
        Preconditions.checkArgument((!password.isEmpty() ? 1 : 0) != 0, (Object)"password can't be empty");
        Preconditions.checkArgument((!virtualHost.isEmpty() ? 1 : 0) != 0, (Object)"virtualHost can't be empty");
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    ConnectionFactory getConnectionFactory() {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setHost(this.host);
        connectionFactory.setPort(this.port);
        connectionFactory.setUsername(this.username);
        connectionFactory.setPassword(this.password);
        connectionFactory.setVirtualHost(this.virtualHost);
        return connectionFactory;
    }

    public String toString() {
        return String.format("%s:%s@%s:%s %s", this.username, this.password, this.host, this.port, this.virtualHost);
    }
}

