/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.mybatis.type;

import com.google.common.base.Strings;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UuidTypeHandler
implements TypeHandler<UUID> {
    private static final Logger LOG = LoggerFactory.getLogger(UuidTypeHandler.class);

    public void setParameter(PreparedStatement ps, int i, UUID parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            ps.setObject(i, null, 1111);
        } else {
            ps.setObject(i, (Object)parameter.toString(), 1111);
        }
    }

    public UUID getResult(ResultSet rs, String columnName) throws SQLException {
        return UuidTypeHandler.toUUID(rs.getString(columnName));
    }

    public UUID getResult(ResultSet rs, int columnIndex) throws SQLException {
        return UuidTypeHandler.toUUID(rs.getString(columnIndex));
    }

    public UUID getResult(CallableStatement cs, int columnIndex) throws SQLException {
        return UuidTypeHandler.toUUID(cs.getString(columnIndex));
    }

    private static UUID toUUID(String val) throws SQLException {
        if (Strings.isNullOrEmpty(val)) {
            return null;
        }
        try {
            return UUID.fromString(val);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Bad UUID found: {}", (Object)val);
            return null;
        }
    }
}

