/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.mybatis.type;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.net.URI;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriArrayTypeHandler
extends BaseTypeHandler<List<URI>> {
    private static final Logger LOG = LoggerFactory.getLogger(UriArrayTypeHandler.class);

    public void setNonNullParameter(PreparedStatement ps, int i, List<URI> parameter, JdbcType jdbcType) throws SQLException {
        Array array = ps.getConnection().createArrayOf("text", parameter.toArray());
        ps.setArray(i, array);
    }

    public List<URI> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.toList(rs.getArray(columnName));
    }

    public List<URI> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.toList(rs.getArray(columnIndex));
    }

    public List<URI> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.toList(cs.getArray(columnIndex));
    }

    private List<URI> toList(Array pgArray) throws SQLException {
        if (pgArray == null) {
            return Lists.newArrayList();
        }
        ArrayList<URI> uris = Lists.newArrayList();
        for (String u : (String[])pgArray.getArray()) {
            if (Strings.isNullOrEmpty(u)) continue;
            try {
                uris.add(URI.create(u));
            }
            catch (Exception e) {
                LOG.error("Failed to convert pg array {} to URI for value {}", (Object)pgArray, (Object)u);
            }
        }
        return uris;
    }
}

