/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.mybatis.type;

import com.google.common.collect.Lists;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class StringArrayTypeHandler
extends BaseTypeHandler<List<String>> {
    public void setNonNullParameter(PreparedStatement ps, int i, List<String> parameter, JdbcType jdbcType) throws SQLException {
        Array array = ps.getConnection().createArrayOf("text", parameter.toArray());
        ps.setArray(i, array);
    }

    public List<String> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.toList(rs.getArray(columnName));
    }

    public List<String> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.toList(rs.getArray(columnIndex));
    }

    public List<String> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.toList(cs.getArray(columnIndex));
    }

    private List<String> toList(Array pgArray) throws SQLException {
        if (pgArray == null) {
            return Lists.newArrayList();
        }
        String[] strings = (String[])pgArray.getArray();
        return Lists.newArrayList(strings);
    }
}

