/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.mybatis.type;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.gbif.api.util.VocabularyUtils;

public class EnumDictTypeHandler<T extends Enum<?>>
implements TypeHandler<T> {
    private final Map<String, T> dict;
    private final Class<T> clazz;
    private final T defaultValue;

    protected EnumDictTypeHandler(Class<T> clazz, @Nullable T defaultValue, @Nullable Map<String, T> lookupDict) {
        this.dict = lookupDict;
        this.clazz = clazz;
        this.defaultValue = defaultValue;
    }

    public void setParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        ps.setObject(i, (Object)(parameter == null ? null : ((Enum)parameter).name()), 1);
    }

    public T getResult(ResultSet rs, String columnName) throws SQLException {
        return this.lookup(rs.getString(columnName));
    }

    public T getResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.lookup(rs.getString(columnIndex));
    }

    public T getResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.lookup(cs.getString(columnIndex));
    }

    @VisibleForTesting
    protected T lookup(String val) {
        try {
            return (T)VocabularyUtils.lookupEnum((String)val, this.clazz);
        }
        catch (IllegalArgumentException e) {
            String normed;
            if (this.dict != null && !Strings.isNullOrEmpty(val) && this.dict.containsKey(normed = val.toLowerCase())) {
                return (T)((Enum)this.dict.get(normed));
            }
            return this.defaultValue;
        }
    }
}

