/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.mybatis.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.gbif.mybatis.type.EnumConverter;

public class BaseEnumTypeHandler<K, T extends Enum<?>>
implements TypeHandler<T> {
    private final EnumConverter<K, T> typeConverter;

    public BaseEnumTypeHandler(EnumConverter<K, T> typeConverter) {
        this.typeConverter = typeConverter;
    }

    public void setParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        ps.setObject(i, this.typeConverter.fromEnum(parameter));
    }

    public T getResult(ResultSet rs, String columnName) throws SQLException {
        return this.toEnum(rs.getObject(columnName));
    }

    public T getResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.toEnum(rs.getObject(columnIndex));
    }

    public T getResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.toEnum(cs.getObject(columnIndex));
    }

    private T toEnum(K termIndex) {
        return this.typeConverter.toEnum(termIndex);
    }
}

