/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.mybatis.type;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Map;
import org.gbif.mybatis.type.EnumConverter;

public abstract class BaseConverter<K, T extends Enum<?>>
implements EnumConverter<K, T> {
    private final BiMap<K, T> map;
    private final T nullValue;

    protected BaseConverter(T nullValue, Map<K, T> map) {
        this.map = ImmutableBiMap.copyOf(map);
        this.nullValue = nullValue;
    }

    @Override
    public T toEnum(K key) {
        if (key == null) {
            return this.nullValue;
        }
        Enum val = (Enum)this.map.get(key);
        return (T)(val == null ? this.nullValue : val);
    }

    @Override
    public K fromEnum(T value) {
        if (value == null) {
            return null;
        }
        if (this.map.containsValue(value)) {
            return (K)this.map.inverse().get(value);
        }
        throw new IllegalArgumentException("Enumeration value " + ((Enum)value).name() + " unknown");
    }
}

