/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.mybatis.guice;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.annotation.Annotation;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.gbif.utils.file.properties.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MyBatisModule
extends org.mybatis.guice.MyBatisModule {
    private static final Logger LOG = LoggerFactory.getLogger(MyBatisModule.class);
    private static final String DEFAULT_MYBATIS_ENV_ID = "default";
    private static final String MYBATIS_ENV_ID = "mybatis.environment.id";
    private static final String MYBATIS_CFG_PREFIX = "mybatis.configuration.";
    private final Key<DataSource> datasourceKey;
    private final Key<SqlSessionManager> sessionManagerKey;
    private final boolean bindDatasource;
    private final Properties properties;
    private final MetricRegistry metricRegistry;
    private final Object healthCheckRegistry;

    public MyBatisModule(Properties properties) {
        this(properties, null, null, null);
    }

    public MyBatisModule(String datasourceBindingName, Properties properties) {
        this(properties, datasourceBindingName, null, null);
    }

    public MyBatisModule(Properties properties, @Nullable String datasourceBindingName, @Nullable MetricRegistry metricRegistry, @Nullable Object healthCheckRegistry) {
        boolean bl = this.bindDatasource = datasourceBindingName != null;
        if (this.bindDatasource) {
            this.datasourceKey = Key.get(DataSource.class, (Annotation)Names.named(datasourceBindingName));
            this.sessionManagerKey = Key.get(SqlSessionManager.class, (Annotation)Names.named(datasourceBindingName));
        } else {
            this.datasourceKey = Key.get(DataSource.class);
            this.sessionManagerKey = Key.get(SqlSessionManager.class);
        }
        this.properties = properties;
        this.metricRegistry = metricRegistry;
        this.healthCheckRegistry = healthCheckRegistry;
    }

    protected void initialize() {
        LogFactory.useSlf4jLogging();
        this.mapUnderscoreToCamelCase(true);
        String myBatisEnvId = this.properties.getProperty(MYBATIS_ENV_ID, DEFAULT_MYBATIS_ENV_ID);
        this.environmentId(myBatisEnvId);
        LOG.debug("Configuring MyBatis environmentId {}", (Object)myBatisEnvId);
        Properties myBatisConfig = PropertiesUtil.removeProperties((Properties)this.properties, (String)MYBATIS_CFG_PREFIX);
        Names.bindProperties(this.binder(), myBatisConfig);
        this.bindTransactionFactoryType(JdbcTransactionFactory.class);
        this.bindMappers();
        this.bindTypeHandlers();
        this.bindManagers();
        if (this.bindDatasource) {
            this.bind(this.datasourceKey).to(DataSource.class);
            this.bind(this.sessionManagerKey).to(SqlSessionManager.class);
        }
    }

    @Provides
    @Singleton
    public DataSource provideDatasource() {
        HikariConfig config = new HikariConfig(this.properties);
        if (this.metricRegistry != null) {
            config.setMetricRegistry((Object)this.metricRegistry);
        }
        if (this.healthCheckRegistry != null) {
            config.setHealthCheckRegistry(this.healthCheckRegistry);
        }
        HikariDataSource ds = new HikariDataSource(config);
        return ds;
    }

    public Key<DataSource> getDatasourceKey() {
        return this.datasourceKey;
    }

    public Key<SqlSessionManager> getSessionManagerKey() {
        return this.sessionManagerKey;
    }

    protected abstract void bindMappers();

    protected abstract void bindTypeHandlers();

    protected abstract void bindManagers();
}

