/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.base.Strings;

public enum NameType {
    SCIENTIFIC,
    VIRUS,
    HYBRID,
    INFORMAL,
    CULTIVAR,
    CANDIDATUS,
    OTU,
    DOUBTFUL,
    PLACEHOLDER,
    NO_NAME;


    public static NameType fromString(String nameType) {
        if (!Strings.isNullOrEmpty((String)nameType)) {
            try {
                return NameType.valueOf(nameType.toUpperCase().trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isBackboneType() {
        return this == SCIENTIFIC || this == VIRUS || this == DOUBTFUL;
    }

    public boolean isParsable() {
        return this == SCIENTIFIC || this == INFORMAL || this == CULTIVAR || this == CANDIDATUS || this == DOUBTFUL;
    }
}

