/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gbif.api.util.VocabularyUtils;

public enum DatasetSubtype {
    TAXONOMIC_AUTHORITY,
    NOMENCLATOR_AUTHORITY,
    INVENTORY_THEMATIC,
    INVENTORY_REGIONAL,
    GLOBAL_SPECIES_DATASET,
    DERIVED_FROM_OCCURRENCE,
    SPECIMEN,
    OBSERVATION;

    public static final Set<DatasetSubtype> OCCURRENCE_DATASET_SUBTYPES;
    public static final Set<DatasetSubtype> CHECKLIST_DATASET_SUBTYPES;

    public static DatasetSubtype fromString(String datasetSubType) {
        return VocabularyUtils.lookupEnum(datasetSubType, DatasetSubtype.class);
    }

    static {
        OCCURRENCE_DATASET_SUBTYPES = ImmutableSet.of((Object)((Object)SPECIMEN), (Object)((Object)OBSERVATION));
        CHECKLIST_DATASET_SUBTYPES = ImmutableSet.of((Object)((Object)TAXONOMIC_AUTHORITY), (Object)((Object)NOMENCLATOR_AUTHORITY), (Object)((Object)INVENTORY_THEMATIC), (Object)((Object)INVENTORY_REGIONAL), (Object)((Object)GLOBAL_SPECIES_DATASET), (Object)((Object)DERIVED_FROM_OCCURRENCE), (Object[])new DatasetSubtype[0]);
    }
}

