/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.util.iterables;

import com.google.common.collect.ImmutableList;
import java.util.UUID;
import javax.annotation.Nullable;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.model.registry.Node;
import org.gbif.api.model.registry.Organization;
import org.gbif.api.service.registry.DatasetService;
import org.gbif.api.service.registry.InstallationService;
import org.gbif.api.service.registry.NetworkService;
import org.gbif.api.service.registry.NodeService;
import org.gbif.api.service.registry.OrganizationService;
import org.gbif.api.util.iterables.DatasetConstituentPager;
import org.gbif.api.util.iterables.DatasetPager;
import org.gbif.api.util.iterables.InstallationPager;
import org.gbif.api.util.iterables.NetworkPager;
import org.gbif.api.util.iterables.NodeDatasetPager;
import org.gbif.api.util.iterables.NodeOrganizationPager;
import org.gbif.api.util.iterables.NodePager;
import org.gbif.api.util.iterables.OrgHostingPager;
import org.gbif.api.util.iterables.OrgPublishingPager;
import org.gbif.api.util.iterables.OrganizationPager;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.DatasetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Iterables {
    private static final Logger LOG = LoggerFactory.getLogger(Iterables.class);

    private Iterables() {
    }

    public static Iterable<Dataset> datasets(@Nullable UUID key, @Nullable DatasetType type, DatasetService ds, OrganizationService os, InstallationService is, NetworkService ns, NodeService nos) {
        return Iterables.datasets(key, type, ds, os, is, ns, nos, 20);
    }

    public static Iterable<Dataset> datasets(@Nullable UUID key, @Nullable DatasetType type, DatasetService ds, OrganizationService os, InstallationService is, NetworkService ns, NodeService nos, int pageSize) {
        if (key == null) {
            LOG.info("Iterate over all {} datasets", type == null ? "" : type);
            return new DatasetPager(ds, type, pageSize);
        }
        if (Iterables.isDataset(key, ds)) {
            LOG.info("Iterate over dataset {}", (Object)key);
            return ImmutableList.of(ds.get(key));
        }
        if (Iterables.isOrganization(key, os)) {
            LOG.info("Iterate over all {} datasets published by {}", type == null ? "" : type, (Object)key);
            return new OrgPublishingPager(os, key, type, pageSize);
        }
        if (Iterables.isInstallation(key, is)) {
            LOG.info("Iterate over all {} datasets hosted by installation {}", type == null ? "" : type, (Object)key);
            return new InstallationPager(is, key, type, pageSize);
        }
        if (Iterables.isNode(key, nos)) {
            LOG.info("Iterate over all {} datasets endorsed by node {}", type == null ? "" : type, (Object)key);
            return new NetworkPager(ns, key, type, pageSize);
        }
        if (Iterables.isNetwork(key, ns)) {
            LOG.info("Iterate over all {} datasets belonging to network {}", type == null ? "" : type, (Object)key);
            return new NodeDatasetPager(nos, key, type, pageSize);
        }
        throw new IllegalArgumentException("Given key is no valid GBIF registry key: " + key);
    }

    public static Iterable<Dataset> datasets(@Nullable DatasetType type, DatasetService service) {
        LOG.info("Iterate over all {} datasets", type == null ? "" : type);
        return new DatasetPager(service, type, 20);
    }

    public static Iterable<Dataset> publishedDatasets(UUID key, @Nullable DatasetType type, OrganizationService service) {
        LOG.info("Iterate over all {} datasets published by {}", type == null ? "" : type, (Object)key);
        return new OrgPublishingPager(service, key, type, 20);
    }

    public static Iterable<Dataset> hostedDatasets(UUID key, @Nullable DatasetType type, OrganizationService service) {
        LOG.info("Iterate over all {} datasets hosted by organization {}", type == null ? "" : type, (Object)key);
        return new OrgHostingPager(service, key, type, 20);
    }

    public static Iterable<Dataset> hostedDatasets(UUID key, @Nullable DatasetType type, InstallationService service) {
        LOG.info("Iterate over all {} datasets hosted by installation {}", type == null ? "" : type, (Object)key);
        return new InstallationPager(service, key, type, 20);
    }

    public static Iterable<Dataset> constituentDatasets(UUID key, DatasetService service) {
        LOG.info("Iterate over all constituent datasets of {}", (Object)key);
        return new DatasetConstituentPager(service, key, 20);
    }

    public static Iterable<Dataset> networkDatasets(UUID key, @Nullable DatasetType type, NetworkService service) {
        LOG.info("Iterate over all {} datasets belonging to network {}", type == null ? "" : type, (Object)key);
        return new NetworkPager(service, key, type, 20);
    }

    public static Iterable<Dataset> endorsedDatasets(UUID nodeKey, @Nullable DatasetType type, NodeService service) {
        LOG.info("Iterate over all {} datasets endorsed by node {}", type == null ? "" : type, (Object)nodeKey);
        return new NodeDatasetPager(service, nodeKey, type, 20);
    }

    public static Iterable<Organization> organizations(@Nullable Country country, OrganizationService service) {
        LOG.info("Iterate over all organizations {}", (Object)(country == null ? "" : "from country " + (Object)((Object)country)));
        return new OrganizationPager(service, country, 20);
    }

    public static Iterable<Organization> endorsedOrganizations(UUID nodeKey, NodeService service) {
        LOG.info("Iterate over all organizations endorsed by node {}", (Object)nodeKey);
        return new NodeOrganizationPager(service, nodeKey, 20);
    }

    public static Iterable<Node> nodes(NodeService service) {
        LOG.info("Iterate over all nodes");
        return new NodePager(service, 20);
    }

    private static boolean isDataset(UUID key, DatasetService ds) {
        return ds.get(key) != null;
    }

    private static boolean isOrganization(UUID key, OrganizationService os) {
        return os.get(key) != null;
    }

    private static boolean isInstallation(UUID key, InstallationService is) {
        return is.get(key) != null;
    }

    private static boolean isNetwork(UUID key, NetworkService ns) {
        return ns.get(key) != null;
    }

    private static boolean isNode(UUID key, NodeService ns) {
        return ns.get(key) != null;
    }
}

