/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.util.iterables;

import javax.annotation.Nullable;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.util.iterables.EntityPager;
import org.gbif.api.vocabulary.DatasetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DatasetBasePager
extends EntityPager<Dataset> {
    private static final Logger LOG = LoggerFactory.getLogger(DatasetBasePager.class);
    private final DatasetType type;

    public DatasetBasePager(@Nullable DatasetType type, int pageSize) {
        super(pageSize);
        this.type = type;
    }

    @Override
    protected boolean exclude(Dataset d) {
        if (d.getParentDatasetKey() != null) {
            LOG.debug("Ignore constituent dataset {} {} of parent {}", new Object[]{d.getKey(), d.getTitle().replaceAll("\n", " "), d.getParentDatasetKey()});
        } else if (this.type != null && d.getType() != this.type) {
            LOG.debug("Ignore {} dataset {}: {}", new Object[]{d.getType(), d.getKey(), d.getTitle().replaceAll("\n", " ")});
        }
        return false;
    }
}

