/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.checklistbank;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.Constants;
import org.gbif.api.model.common.LinneanClassification;
import org.gbif.api.model.common.LinneanClassificationKeys;
import org.gbif.api.util.ClassificationUtils;
import org.gbif.api.vocabulary.NameType;
import org.gbif.api.vocabulary.NameUsageIssue;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.gbif.api.vocabulary.Origin;
import org.gbif.api.vocabulary.Rank;
import org.gbif.api.vocabulary.TaxonomicStatus;

public class NameUsage
implements LinneanClassification,
LinneanClassificationKeys {
    private Integer key;
    private Integer nubKey;
    private Integer nameKey;
    private String taxonID;
    private Integer sourceTaxonKey;
    private String kingdom;
    private String phylum;
    @JsonProperty(value="class")
    private String clazz;
    private String order;
    private String family;
    private String genus;
    private String subgenus;
    private String species;
    private Integer kingdomKey;
    private Integer phylumKey;
    private Integer classKey;
    private Integer orderKey;
    private Integer familyKey;
    private Integer genusKey;
    private Integer subgenusKey;
    private Integer speciesKey;
    private UUID datasetKey;
    private UUID constituentKey;
    private Integer parentKey;
    private String parent;
    private Integer proParteKey;
    private Integer acceptedKey;
    private String accepted;
    private Integer basionymKey;
    private String basionym;
    private String scientificName;
    private String canonicalName;
    private String vernacularName;
    private String authorship;
    private NameType nameType;
    private Rank rank;
    private Origin origin;
    private TaxonomicStatus taxonomicStatus;
    private Set<NomenclaturalStatus> nomenclaturalStatus = Sets.newHashSet();
    private String remarks;
    private String publishedIn;
    private String accordingTo;
    private int numDescendants;
    private URI references;
    private Date modified;
    private Date deleted;
    private Date lastCrawled;
    private Date lastInterpreted;
    private Set<NameUsageIssue> issues = EnumSet.noneOf(NameUsageIssue.class);

    public Integer getNameKey() {
        return this.nameKey;
    }

    public void setNameKey(Integer nameKey) {
        this.nameKey = nameKey;
    }

    @Nullable
    public Integer getSourceTaxonKey() {
        return this.sourceTaxonKey;
    }

    public void setSourceTaxonKey(Integer sourceTaxonKey) {
        this.sourceTaxonKey = sourceTaxonKey;
    }

    public String getAccepted() {
        return this.accepted;
    }

    public void setAccepted(String accepted) {
        this.accepted = accepted;
    }

    public Integer getAcceptedKey() {
        return this.acceptedKey;
    }

    public void setAcceptedKey(Integer acceptedKey) {
        this.acceptedKey = acceptedKey;
    }

    @Nullable
    public String getAccordingTo() {
        return this.accordingTo;
    }

    public void setAccordingTo(String accordingTo) {
        this.accordingTo = accordingTo;
    }

    @Nullable
    public String getAuthorship() {
        return this.authorship;
    }

    public void setAuthorship(String authorship) {
        this.authorship = authorship;
    }

    public String getBasionym() {
        return this.basionym;
    }

    public void setBasionym(String basionym) {
        this.basionym = basionym;
    }

    @Nullable
    public Integer getBasionymKey() {
        return this.basionymKey;
    }

    public void setBasionymKey(Integer basionymKey) {
        this.basionymKey = basionymKey;
    }

    @Nullable
    public String getCanonicalName() {
        return this.canonicalName;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    @NotNull
    public UUID getDatasetKey() {
        return this.datasetKey;
    }

    public void setDatasetKey(UUID datasetKey) {
        this.datasetKey = datasetKey;
    }

    @NotNull
    public Integer getKey() {
        return this.key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    public NameType getNameType() {
        return this.nameType;
    }

    public void setNameType(NameType nameType) {
        this.nameType = nameType;
    }

    public Set<NomenclaturalStatus> getNomenclaturalStatus() {
        return this.nomenclaturalStatus;
    }

    public void setNomenclaturalStatus(Set<NomenclaturalStatus> nomenclaturalStatus) {
        this.nomenclaturalStatus = nomenclaturalStatus;
    }

    @Nullable
    public Integer getNubKey() {
        return this.nubKey;
    }

    public void setNubKey(Integer nubKey) {
        this.nubKey = nubKey;
    }

    public int getNumDescendants() {
        return this.numDescendants;
    }

    public void setNumDescendants(int numDescendants) {
        this.numDescendants = numDescendants;
    }

    @NotNull
    public Origin getOrigin() {
        return this.origin;
    }

    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    @Nullable
    public Integer getParentKey() {
        return this.parentKey;
    }

    public void setParentKey(Integer parentKey) {
        this.parentKey = parentKey;
    }

    public Integer getProParteKey() {
        return this.proParteKey;
    }

    public void setProParteKey(Integer proParteKey) {
        this.proParteKey = proParteKey;
    }

    @Nullable
    public String getPublishedIn() {
        return this.publishedIn;
    }

    public void setPublishedIn(String publishedIn) {
        this.publishedIn = publishedIn;
    }

    @Nullable
    public Rank getRank() {
        return this.rank;
    }

    public void setRank(Rank rank) {
        this.rank = rank;
    }

    @NotNull
    public String getScientificName() {
        return this.scientificName;
    }

    public void setScientificName(String scientificName) {
        this.scientificName = scientificName;
    }

    @Nullable
    public UUID getConstituentKey() {
        return this.constituentKey;
    }

    public void setConstituentKey(UUID constituentKey) {
        this.constituentKey = constituentKey;
    }

    @Nullable
    public String getVernacularName() {
        return this.vernacularName;
    }

    public void setVernacularName(String vernacularName) {
        this.vernacularName = vernacularName;
    }

    public void setTaxonomicStatus(TaxonomicStatus taxonomicStatus) {
        this.taxonomicStatus = taxonomicStatus;
    }

    @Override
    public String getKingdom() {
        return this.kingdom;
    }

    @Override
    public void setKingdom(String kingdom) {
        this.kingdom = kingdom;
    }

    @Override
    public String getPhylum() {
        return this.phylum;
    }

    @Override
    public void setPhylum(String phylum) {
        this.phylum = phylum;
    }

    @Override
    public String getClazz() {
        return this.clazz;
    }

    @Override
    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    @Override
    public String getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(String order) {
        this.order = order;
    }

    @Override
    public String getFamily() {
        return this.family;
    }

    @Override
    public void setFamily(String family) {
        this.family = family;
    }

    @Override
    public String getGenus() {
        return this.genus;
    }

    @Override
    public void setGenus(String genus) {
        this.genus = genus;
    }

    @Override
    public String getSubgenus() {
        return this.subgenus;
    }

    @Override
    public void setSubgenus(String subgenus) {
        this.subgenus = subgenus;
    }

    @Override
    public String getSpecies() {
        return this.species;
    }

    @Override
    public void setSpecies(String species) {
        this.species = species;
    }

    @Override
    public Integer getKingdomKey() {
        return this.kingdomKey;
    }

    @Override
    public void setKingdomKey(Integer kingdomKey) {
        this.kingdomKey = kingdomKey;
    }

    @Override
    public Integer getPhylumKey() {
        return this.phylumKey;
    }

    @Override
    public void setPhylumKey(Integer phylumKey) {
        this.phylumKey = phylumKey;
    }

    @Override
    public Integer getClassKey() {
        return this.classKey;
    }

    @Override
    public void setClassKey(Integer classKey) {
        this.classKey = classKey;
    }

    @Override
    public Integer getOrderKey() {
        return this.orderKey;
    }

    @Override
    public void setOrderKey(Integer orderKey) {
        this.orderKey = orderKey;
    }

    @Override
    public Integer getFamilyKey() {
        return this.familyKey;
    }

    @Override
    public void setFamilyKey(Integer familyKey) {
        this.familyKey = familyKey;
    }

    @Override
    public Integer getGenusKey() {
        return this.genusKey;
    }

    @Override
    public void setGenusKey(Integer genusKey) {
        this.genusKey = genusKey;
    }

    @Override
    public Integer getSubgenusKey() {
        return this.subgenusKey;
    }

    @Override
    public void setSubgenusKey(Integer subgenusKey) {
        this.subgenusKey = subgenusKey;
    }

    @Override
    public Integer getSpeciesKey() {
        return this.speciesKey;
    }

    @Override
    public void setSpeciesKey(Integer speciesKey) {
        this.speciesKey = speciesKey;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Nullable
    @JsonIgnore
    public String getCanonicalOrScientificName() {
        return this.canonicalName == null ? this.scientificName : this.canonicalName;
    }

    @Nullable
    public URI getReferences() {
        return this.references;
    }

    public void setReferences(URI references) {
        this.references = references;
    }

    @Override
    public String getHigherRank(Rank rank) {
        return ClassificationUtils.getHigherRank(this, rank);
    }

    @Override
    public Integer getHigherRankKey(Rank rank) {
        return ClassificationUtils.getHigherRankKey(this, rank);
    }

    @NotNull
    @JsonIgnore
    public LinkedHashMap<Integer, String> getHigherClassificationMap() {
        return ClassificationUtils.getHigherClassificationMap(this, this.key, this.parentKey, this.parent);
    }

    @Nullable
    public String getTaxonID() {
        return this.taxonID;
    }

    @Nullable
    public TaxonomicStatus getTaxonomicStatus() {
        return this.taxonomicStatus;
    }

    @Nullable
    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Nullable
    public Date getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Date deleted) {
        this.deleted = deleted;
    }

    @Nullable
    public Date getLastCrawled() {
        return this.lastCrawled;
    }

    public void setLastCrawled(Date lastCrawled) {
        this.lastCrawled = lastCrawled;
    }

    @Nullable
    public Date getLastInterpreted() {
        return this.lastInterpreted;
    }

    public void setLastInterpreted(Date lastInterpreted) {
        this.lastInterpreted = lastInterpreted;
    }

    @NotNull
    public Set<NameUsageIssue> getIssues() {
        return this.issues;
    }

    public void setIssues(Set<NameUsageIssue> issues) {
        Preconditions.checkNotNull(issues, (Object)"Issues cannot be null");
        this.issues = Sets.newEnumSet(issues, NameUsageIssue.class);
    }

    public void addIssue(NameUsageIssue issue) {
        Preconditions.checkNotNull((Object)issue, (Object)"Issue needs to be specified");
        this.issues.add(issue);
    }

    @JsonIgnore
    public boolean isNub() {
        return this.datasetKey.equals(Constants.NUB_DATASET_KEY);
    }

    @JsonIgnore
    public boolean isProParte() {
        return this.proParteKey != null;
    }

    public boolean isSynonym() {
        return this.taxonomicStatus != null && this.taxonomicStatus.isSynonym();
    }

    public void setTaxonID(String taxonID) {
        this.taxonID = taxonID;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.nameKey, this.kingdom, this.phylum, this.clazz, this.order, this.family, this.genus, this.subgenus, this.species, this.kingdomKey, this.phylumKey, this.classKey, this.orderKey, this.familyKey, this.genusKey, this.subgenusKey, this.speciesKey, this.datasetKey, this.constituentKey, this.nubKey, this.parentKey, this.parent, this.proParteKey, this.acceptedKey, this.accepted, this.basionymKey, this.basionym, this.scientificName, this.canonicalName, this.vernacularName, this.authorship, this.nameType, this.taxonomicStatus, this.nomenclaturalStatus, this.rank, this.publishedIn, this.accordingTo, this.numDescendants, this.origin, this.remarks, this.references, this.taxonID, this.modified, this.deleted, this.lastCrawled, this.lastInterpreted, this.issues});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NameUsage other = (NameUsage)obj;
        return Objects.equal((Object)this.key, (Object)other.key) && Objects.equal((Object)this.nameKey, (Object)other.nameKey) && Objects.equal((Object)this.kingdom, (Object)other.kingdom) && Objects.equal((Object)this.phylum, (Object)other.phylum) && Objects.equal((Object)this.clazz, (Object)other.clazz) && Objects.equal((Object)this.order, (Object)other.order) && Objects.equal((Object)this.family, (Object)other.family) && Objects.equal((Object)this.genus, (Object)other.genus) && Objects.equal((Object)this.subgenus, (Object)other.subgenus) && Objects.equal((Object)this.species, (Object)other.species) && Objects.equal((Object)this.kingdomKey, (Object)other.kingdomKey) && Objects.equal((Object)this.phylumKey, (Object)other.phylumKey) && Objects.equal((Object)this.classKey, (Object)other.classKey) && Objects.equal((Object)this.orderKey, (Object)other.orderKey) && Objects.equal((Object)this.familyKey, (Object)other.familyKey) && Objects.equal((Object)this.genusKey, (Object)other.genusKey) && Objects.equal((Object)this.subgenusKey, (Object)other.subgenusKey) && Objects.equal((Object)this.speciesKey, (Object)other.speciesKey) && Objects.equal((Object)this.datasetKey, (Object)other.datasetKey) && Objects.equal((Object)this.constituentKey, (Object)other.constituentKey) && Objects.equal((Object)this.nubKey, (Object)other.nubKey) && Objects.equal((Object)this.parentKey, (Object)other.parentKey) && Objects.equal((Object)this.parent, (Object)other.parent) && Objects.equal((Object)this.proParteKey, (Object)other.proParteKey) && Objects.equal((Object)this.acceptedKey, (Object)other.acceptedKey) && Objects.equal((Object)this.accepted, (Object)other.accepted) && Objects.equal((Object)this.basionymKey, (Object)other.basionymKey) && Objects.equal((Object)this.basionym, (Object)other.basionym) && Objects.equal((Object)this.scientificName, (Object)other.scientificName) && Objects.equal((Object)this.canonicalName, (Object)other.canonicalName) && Objects.equal((Object)this.vernacularName, (Object)other.vernacularName) && Objects.equal((Object)this.authorship, (Object)other.authorship) && Objects.equal((Object)((Object)this.nameType), (Object)((Object)other.nameType)) && Objects.equal((Object)((Object)this.taxonomicStatus), (Object)((Object)other.taxonomicStatus)) && Objects.equal(this.nomenclaturalStatus, other.nomenclaturalStatus) && Objects.equal((Object)((Object)this.rank), (Object)((Object)other.rank)) && Objects.equal((Object)this.publishedIn, (Object)other.publishedIn) && Objects.equal((Object)this.accordingTo, (Object)other.accordingTo) && Objects.equal((Object)this.numDescendants, (Object)other.numDescendants) && Objects.equal((Object)((Object)this.origin), (Object)((Object)other.origin)) && Objects.equal((Object)this.references, (Object)other.references) && Objects.equal((Object)this.taxonID, (Object)other.taxonID) && Objects.equal((Object)this.remarks, (Object)other.remarks) && Objects.equal((Object)this.modified, (Object)other.modified) && Objects.equal((Object)this.deleted, (Object)other.deleted) && Objects.equal((Object)this.lastCrawled, (Object)other.lastCrawled) && Objects.equal((Object)this.lastInterpreted, (Object)other.lastInterpreted) && Objects.equal(this.issues, other.issues);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("key", (Object)this.key).add("nameKey", (Object)this.nameKey).add("kingdom", (Object)this.kingdom).add("phylum", (Object)this.phylum).add("clazz", (Object)this.clazz).add("order", (Object)this.order).add("family", (Object)this.family).add("genus", (Object)this.genus).add("subgenus", (Object)this.subgenus).add("species", (Object)this.species).add("kingdomKey", (Object)this.kingdomKey).add("phylumKey", (Object)this.phylumKey).add("classKey", (Object)this.classKey).add("orderKey", (Object)this.orderKey).add("familyKey", (Object)this.familyKey).add("genusKey", (Object)this.genusKey).add("subgenusKey", (Object)this.subgenusKey).add("speciesKey", (Object)this.speciesKey).add("datasetKey", (Object)this.datasetKey).add("subDatasetKey", (Object)this.constituentKey).add("nubKey", (Object)this.nubKey).add("parentKey", (Object)this.parentKey).add("parent", (Object)this.parent).add("proParteKey", (Object)this.proParteKey).add("acceptedKey", (Object)this.acceptedKey).add("accepted", (Object)this.accepted).add("basionymKey", (Object)this.basionymKey).add("basionym", (Object)this.basionym).add("scientificName", (Object)this.scientificName).add("canonicalName", (Object)this.canonicalName).add("vernacularName", (Object)this.vernacularName).add("authorship", (Object)this.authorship).add("nameType", (Object)this.nameType).add("taxonomicStatus", (Object)this.taxonomicStatus).add("nomenclaturalStatus", this.nomenclaturalStatus).add("rank", (Object)this.rank).add("publishedIn", (Object)this.publishedIn).add("accordingTo", (Object)this.accordingTo).add("numDescendants", this.numDescendants).add("origin", (Object)this.origin).add("remarks", (Object)this.remarks).add("references", (Object)this.references).add("taxonID", (Object)this.taxonID).add("modified", (Object)this.modified).add("deleted", (Object)this.deleted).add("lastCrawled", (Object)this.lastCrawled).add("lastInterpreted", (Object)this.lastInterpreted).add("issues", this.issues).toString();
    }
}

