/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.jackson;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.gbif.api.vocabulary.Rank;

public class RankSerde {

    public static class RankJsonDeserializer
    extends JsonDeserializer<Rank> {
        private static final Map<String, Rank> ranks = Maps.newHashMap();

        public Rank deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            if (jp.getCurrentToken() == JsonToken.VALUE_STRING) {
                if (ranks.containsKey(jp.getText())) {
                    return ranks.get(jp.getText());
                }
                try {
                    return Rank.valueOf(jp.getText().toUpperCase().replaceAll(" ", "_"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
            throw ctxt.mappingException("Expected String");
        }

        static {
            for (Rank r : Rank.values()) {
                if (r.getMarker() == null) continue;
                ranks.put(r.getMarker(), r);
            }
        }
    }

    public static class RankJsonSerializer
    extends JsonSerializer<Rank> {
        public void serialize(Rank value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value == null) {
                jgen.writeNull();
                return;
            }
            if (value.getMarker() == null) {
                jgen.writeString(value.name().toLowerCase().replaceAll("_", " "));
            } else {
                jgen.writeString(value.getMarker());
            }
        }
    }
}

