/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.service.guice;

import com.google.inject.Binder;
import com.google.inject.PrivateModule;
import com.google.inject.name.Names;
import java.util.Properties;
import org.gbif.utils.file.properties.PropertiesUtil;

public abstract class PrivateServiceModule
extends PrivateModule {
    private final String propertyPrefix;
    private final Properties properties;
    private final Properties verbatimProperties;

    public PrivateServiceModule(String propertyPrefix, Properties properties) {
        this.propertyPrefix = propertyPrefix;
        this.verbatimProperties = properties;
        this.properties = PropertiesUtil.filterProperties((Properties)properties, (String)propertyPrefix);
    }

    protected final void configure() {
        Names.bindProperties((Binder)this.binder(), (Properties)this.properties);
        this.configureService();
    }

    protected abstract void configureService();

    protected Properties getProperties() {
        return this.properties;
    }

    protected Properties getVerbatimProperties() {
        return this.verbatimProperties;
    }
}

