/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.nameparser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gbif.api.model.checklistbank.ParsedName;
import org.gbif.api.vocabulary.NomenclaturalCode;
import org.gbif.api.vocabulary.Rank;

public class RankUtils {
    private static final Pattern NORMALIZE_RANK_MARKER = Pattern.compile("(?:[._ -]+|\\bnotho)");
    protected static final List<Rank> INFRASUBSPECIFIC_MICROBIAL_RANKS;
    protected static final Map<String, Rank> RANK_MARKER_MAP_SUPRAGENERIC;
    protected static final Map<String, Rank> RANK_MARKER_MAP_INFRAGENERIC;
    protected static final Map<String, Rank> RANK_MARKER_MAP_INFRASPECIFIC;
    protected static final Map<String, Rank> RANK_MARKER_MAP;
    protected static final SortedMap<String, Rank> SUFFICES_RANK_MAP;

    public static Rank inferRank(@Nullable String rankMarker) {
        if (rankMarker != null) {
            return RANK_MARKER_MAP.get(NORMALIZE_RANK_MARKER.matcher(rankMarker.toLowerCase()).replaceAll(""));
        }
        return null;
    }

    public static Rank inferRank(ParsedName pn) {
        Rank inferred = RankUtils.inferRank(pn.getGenusOrAbove(), pn.getInfraGeneric(), pn.getSpecificEpithet(), null, pn.getInfraSpecificEpithet());
        if (inferred != null && inferred.notOtherOrUnknown()) {
            return inferred;
        }
        return null;
    }

    public static Rank inferRank(@Nullable String genusOrAbove, @Nullable String infraGeneric, @Nullable String specificEpithet, @Nullable String rankMarker, @Nullable String infraSpecificEpithet) {
        Rank markerRank = RankUtils.inferRank(rankMarker);
        if (markerRank != null) {
            return markerRank;
        }
        Rank rank = Rank.UNRANKED;
        if (infraSpecificEpithet != null) {
            rank = Rank.INFRASPECIFIC_NAME;
        } else if (specificEpithet != null) {
            rank = Rank.SPECIES;
        } else if (infraGeneric != null) {
            rank = Rank.INFRAGENERIC_NAME;
        } else if (genusOrAbove != null) {
            for (String suffix : SUFFICES_RANK_MAP.keySet()) {
                if (!genusOrAbove.endsWith(suffix)) continue;
                rank = (Rank)((Object)SUFFICES_RANK_MAP.get(suffix));
                break;
            }
        }
        return rank;
    }

    static {
        ArrayList microbialRanks = Lists.newArrayList();
        for (Rank r : Rank.values()) {
            if (r.isRestrictedToCode() != NomenclaturalCode.BACTERIAL || !r.isInfraspecific()) continue;
            microbialRanks.add(r);
        }
        INFRASUBSPECIFIC_MICROBIAL_RANKS = ImmutableList.copyOf((Collection)microbialRanks);
        HashMap ranks = Maps.newHashMap();
        for (Rank r : Rank.values()) {
            if (!r.isSuprageneric() || r.getMarker() == null) continue;
            ranks.put(r.getMarker().replaceAll("\\.", ""), r);
        }
        ranks.put("fam", Rank.FAMILY);
        ranks.put("gen", Rank.GENUS);
        ranks.put("ib", Rank.SUPRAGENERIC_NAME);
        ranks.put("sect", Rank.SECTION);
        ranks.put("supersubtrib", Rank.SUPRAGENERIC_NAME);
        ranks.put("trib", Rank.TRIBE);
        RANK_MARKER_MAP_SUPRAGENERIC = ImmutableMap.copyOf((Map)ranks);
        ranks = Maps.newHashMap();
        for (Rank r : Rank.values()) {
            if (!r.isInfrageneric() || r.isSpeciesOrBelow() || r.getMarker() == null) continue;
            ranks.put(r.getMarker().replaceAll("\\.", ""), r);
        }
        ranks.put("sl", Rank.SPECIES_AGGREGATE);
        ranks.put("aggr", Rank.SPECIES_AGGREGATE);
        ranks.put("sect", Rank.SECTION);
        ranks.put("section", Rank.SECTION);
        ranks.put("ser", Rank.SERIES);
        ranks.put("series", Rank.SERIES);
        ranks.put("sp", Rank.SPECIES);
        ranks.put("spec", Rank.SPECIES);
        ranks.put("species", Rank.SPECIES);
        ranks.put("spp", Rank.SPECIES);
        ranks.put("subg", Rank.SUBGENUS);
        ranks.put("subgen", Rank.SUBGENUS);
        ranks.put("subgenus", Rank.SUBGENUS);
        ranks.put("subsect", Rank.SUBSECTION);
        ranks.put("subsection", Rank.SUBSECTION);
        ranks.put("subser", Rank.SUBSERIES);
        ranks.put("subseries", Rank.SUBSERIES);
        RANK_MARKER_MAP_INFRAGENERIC = ImmutableMap.copyOf((Map)ranks);
        ranks = Maps.newHashMap();
        for (Rank r : Rank.values()) {
            if (!r.isInfraspecific() || r.getMarker() == null) continue;
            ranks.put(r.getMarker().replaceAll("\\.", ""), r);
        }
        ranks.put("aberration", Rank.ABERRATION);
        ranks.put("bv", Rank.BIOVAR);
        ranks.put("conv", Rank.CONVARIETY);
        ranks.put("ct", Rank.CHEMOFORM);
        ranks.put("cv", Rank.CULTIVAR);
        ranks.put("f", Rank.FORM);
        ranks.put("fo", Rank.FORM);
        ranks.put("form", Rank.FORM);
        ranks.put("forma", Rank.FORM);
        ranks.put("fsp", Rank.FORMA_SPECIALIS);
        ranks.put("fspec", Rank.FORMA_SPECIALIS);
        ranks.put("gx", Rank.GREX);
        ranks.put("hort", Rank.CULTIVAR);
        ranks.put("m", Rank.MORPH);
        ranks.put("morpha", Rank.MORPH);
        ranks.put("nat", Rank.NATIO);
        ranks.put("proles", Rank.PROLES);
        ranks.put("pv", Rank.PATHOVAR);
        ranks.put("sf", Rank.SUBFORM);
        ranks.put("ssp", Rank.SUBSPECIES);
        ranks.put("st", Rank.STRAIN);
        ranks.put("subf", Rank.SUBFORM);
        ranks.put("subform", Rank.SUBFORM);
        ranks.put("subsp", Rank.SUBSPECIES);
        ranks.put("subv", Rank.SUBVARIETY);
        ranks.put("subvar", Rank.SUBVARIETY);
        ranks.put("sv", Rank.SUBVARIETY);
        ranks.put("v", Rank.VARIETY);
        ranks.put("var", Rank.VARIETY);
        ranks.put("\\*+", Rank.INFRASPECIFIC_NAME);
        RANK_MARKER_MAP_INFRASPECIFIC = ImmutableMap.copyOf((Map)ranks);
        ranks = Maps.newHashMap();
        for (Rank r : Rank.values()) {
            if (r.getMarker() == null) continue;
            ranks.put(r.getMarker().replaceAll("\\.", ""), r);
        }
        ranks.putAll(RANK_MARKER_MAP_SUPRAGENERIC);
        ranks.putAll(RANK_MARKER_MAP_INFRAGENERIC);
        ranks.putAll(RANK_MARKER_MAP_INFRASPECIFIC);
        ranks.put("subser", Rank.SUBSERIES);
        RANK_MARKER_MAP = ImmutableMap.copyOf((Map)ranks);
        SUFFICES_RANK_MAP = new ImmutableSortedMap.Builder((Comparator)Ordering.natural()).put((Object)"mycetidae", (Object)Rank.SUBCLASS).put((Object)"phycidae", (Object)Rank.SUBCLASS).put((Object)"mycotina", (Object)Rank.SUBPHYLUM).put((Object)"phytina", (Object)Rank.SUBPHYLUM).put((Object)"phyceae", (Object)Rank.CLASS).put((Object)"mycetes", (Object)Rank.CLASS).put((Object)"mycota", (Object)Rank.PHYLUM).put((Object)"opsida", (Object)Rank.CLASS).put((Object)"oideae", (Object)Rank.SUBFAMILY).put((Object)"aceae", (Object)Rank.FAMILY).put((Object)"phyta", (Object)Rank.PHYLUM).put((Object)"oidea", (Object)Rank.SUPERFAMILY).put((Object)"ineae", (Object)Rank.SUBORDER).put((Object)"anae", (Object)Rank.SUPERORDER).put((Object)"ales", (Object)Rank.ORDER).put((Object)"acea", (Object)Rank.SUPERFAMILY).put((Object)"idae", (Object)Rank.FAMILY).put((Object)"inae", (Object)Rank.SUBFAMILY).put((Object)"eae", (Object)Rank.TRIBE).put((Object)"ini", (Object)Rank.TRIBE).put((Object)"ina", (Object)Rank.SUBTRIBE).build();
    }
}

