/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.doi.registration;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.gbif.api.model.common.DOI;
import org.gbif.registry.doi.DoiType;

public class DoiRegistration {
    @JsonSerialize(using=DOI.Serializer.class)
    @JsonDeserialize(using=DOI.Deserializer.class)
    @Nullable
    private DOI doi;
    @Nullable
    private String key;
    private String metadata;
    private DoiType type;
    private String user;

    public DoiRegistration() {
    }

    private DoiRegistration(DOI doi, String key, String metadata, DoiType type, String user) {
        this.doi = doi;
        this.key = key;
        this.metadata = metadata;
        this.type = type;
        this.user = user;
    }

    public DOI getDoi() {
        return this.doi;
    }

    public void setDoi(DOI doi) {
        this.doi = doi;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public DoiType getType() {
        return this.type;
    }

    public void setType(DoiType type) {
        this.type = type;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("key", this.key).add("doi", this.doi).add("metadata", this.metadata).add("type", (Object)this.type).add("user", this.user).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoiRegistration)) {
            return false;
        }
        DoiRegistration that = (DoiRegistration)obj;
        return Objects.equal(this.key, that.key) && Objects.equal(this.doi, that.doi) && Objects.equal(this.metadata, that.metadata) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.key, this.doi, this.metadata, this.type, this.user});
    }

    public static class Builder {
        private DOI doi;
        private String key;
        private String metadata;
        private DoiType type;
        private String user;

        public Builder withDoi(DOI doi) {
            this.doi = doi;
            return this;
        }

        public Builder withKey(String key) {
            this.key = key;
            return this;
        }

        public Builder withMetadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder withType(DoiType type) {
            this.type = type;
            return this;
        }

        public Builder withUser(String user) {
            this.user = user;
            return this;
        }

        public DoiRegistration build() {
            return new DoiRegistration(this.doi, this.key, this.metadata, this.type, this.user);
        }
    }
}

