/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.doi.generator;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.gbif.api.model.common.DOI;
import org.gbif.api.model.common.DoiData;
import org.gbif.api.model.common.DoiStatus;
import org.gbif.common.messaging.api.Message;
import org.gbif.common.messaging.api.MessagePublisher;
import org.gbif.common.messaging.api.messages.ChangeDoiMessage;
import org.gbif.doi.metadata.datacite.DataCiteMetadata;
import org.gbif.doi.service.InvalidMetadataException;
import org.gbif.doi.service.datacite.DataCiteValidator;
import org.gbif.registry.doi.DoiPersistenceService;
import org.gbif.registry.doi.DoiType;
import org.gbif.registry.doi.generator.DoiGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoiGeneratorMQ
implements DoiGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DoiGeneratorMQ.class);
    private final DoiPersistenceService doiPersistenceService;
    private final URI datasetTarget;
    private final URI downloadTarget;
    private final URI dataPackageTarget;
    private final String prefix;
    private static final int RANDOM_LENGTH = 6;
    @Inject(optional=true)
    private final MessagePublisher messagePublisher = null;

    @Inject
    public DoiGeneratorMQ(DoiPersistenceService doiPersistenceService, @Named(value="portal.url") URI portal, @Named(value="doi.prefix") String prefix) {
        Preconditions.checkArgument(prefix.startsWith("10."), "DOI prefix must begin with 10.");
        this.prefix = prefix;
        this.doiPersistenceService = doiPersistenceService;
        Preconditions.checkNotNull(portal, "portal base URL can't be null");
        Preconditions.checkArgument(portal.isAbsolute(), "portal base URL must be absolute");
        this.datasetTarget = portal.resolve("dataset/");
        this.downloadTarget = portal.resolve("occurrence/download/");
        this.dataPackageTarget = portal.resolve("data_package/");
    }

    private DOI newDOI(String shoulder, DoiType type) {
        for (int x = 0; x < 100; ++x) {
            DOI doi = this.random(shoulder);
            try {
                this.doiPersistenceService.create(doi, type);
                return doi;
            }
            catch (PersistenceException e) {
                LOG.debug("Random {} DOI {} existed. Try another one", new Object[]{type, doi, e.getMessage()});
                continue;
            }
        }
        throw new IllegalStateException("Tried 100 random DOIs and none worked, Giving up");
    }

    @Override
    public DOI newDatasetDOI() {
        return this.newDOI("", DoiType.DATASET);
    }

    @Override
    public DOI newDownloadDOI() {
        return this.newDOI("dl.", DoiType.DOWNLOAD);
    }

    @Override
    public DOI newDataPackageDOI() {
        return this.newDOI("dp.", DoiType.DATA_PACKAGE);
    }

    @Override
    public boolean isGbif(DOI doi) {
        return doi != null && doi.getPrefix().equalsIgnoreCase(this.prefix);
    }

    @Override
    public void failed(DOI doi, InvalidMetadataException e) {
        this.doiPersistenceService.update(doi, new DoiData(DoiStatus.FAILED, null), ExceptionUtils.getStackTrace((Throwable)e));
    }

    private DOI random(@Nullable String shoulder) {
        String suffix = Strings.nullToEmpty(shoulder) + RandomStringUtils.randomAlphanumeric((int)6);
        return new DOI(this.prefix, suffix);
    }

    @Override
    public void registerDataset(DOI doi, DataCiteMetadata metadata, UUID datasetKey) throws InvalidMetadataException {
        Preconditions.checkNotNull(doi, "DOI required");
        Preconditions.checkNotNull(datasetKey, "Dataset key required");
        Preconditions.checkNotNull(this.messagePublisher, "No message publisher configured to send DoiChangeMessage");
        String xml = DataCiteValidator.toXml(doi, metadata);
        ChangeDoiMessage message = new ChangeDoiMessage(DoiStatus.REGISTERED, doi, xml, this.datasetTarget.resolve(datasetKey.toString()));
        try {
            this.messagePublisher.send((Message)message, true);
        }
        catch (IOException e) {
            LOG.error("Failed sending DoiChangeMessage for {} and dataset {}", new Object[]{doi, datasetKey, e});
        }
    }

    @Override
    public void registerDownload(DOI doi, DataCiteMetadata metadata, String downloadKey) throws InvalidMetadataException {
        Preconditions.checkNotNull(doi, "DOI required");
        Preconditions.checkNotNull(downloadKey, "Download key required");
        Preconditions.checkNotNull(this.messagePublisher, "No message publisher configured to send DoiChangeMessage");
        String xml = DataCiteValidator.toXml(doi, metadata);
        ChangeDoiMessage message = new ChangeDoiMessage(DoiStatus.REGISTERED, doi, xml, this.downloadTarget.resolve(downloadKey));
        try {
            this.messagePublisher.send((Message)message, true);
        }
        catch (IOException e) {
            LOG.error("Failed sending DoiChangeMessage for {} and download {}", new Object[]{doi, downloadKey, e});
        }
    }

    @Override
    public void registerDataPackage(DOI doi, DataCiteMetadata metadata) throws InvalidMetadataException {
        Preconditions.checkNotNull(doi, "DOI required");
        Preconditions.checkNotNull(this.messagePublisher, "No message publisher configured to send DoiChangeMessage");
        String xml = DataCiteValidator.toXml(doi, metadata);
        ChangeDoiMessage message = new ChangeDoiMessage(DoiStatus.REGISTERED, doi, xml, this.dataPackageTarget.resolve(doi.getDoiName()));
        try {
            this.messagePublisher.send((Message)message, true);
        }
        catch (IOException e) {
            LOG.error("Failed sending DoiChangeMessage for DataPackage {}", (Object)doi, (Object)e);
        }
    }

    @Override
    public void delete(DOI doi) {
        Preconditions.checkNotNull(doi, "DOI required");
        Preconditions.checkNotNull(this.messagePublisher, "No message publisher configured to send DoiChangeMessage");
        ChangeDoiMessage message = new ChangeDoiMessage(DoiStatus.DELETED, doi, null, null);
        try {
            this.messagePublisher.send((Message)message, true);
        }
        catch (IOException e) {
            LOG.error("Failed sending DoiChangeMessage for {}", (Object)doi, (Object)e);
        }
    }
}

