/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.doi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.gbif.api.model.common.DOI;
import org.gbif.api.model.registry.DatasetOccurrenceDownloadUsage;
import org.gbif.api.vocabulary.IdentifierType;
import org.gbif.doi.metadata.datacite.DataCiteMetadata;
import org.gbif.doi.metadata.datacite.DateType;
import org.gbif.doi.metadata.datacite.DescriptionType;
import org.gbif.doi.metadata.datacite.RelatedIdentifierType;
import org.gbif.doi.metadata.datacite.RelationType;
import org.gbif.doi.metadata.datacite.ResourceType;
import org.gbif.registry.doi.DataCiteConverter;

public class CustomDownloadDataCiteConverter {
    private static final String CUSTOM_DOWNLOAD_TITLE = "GBIF Custom Occurrence Download";
    private static final String DOWNLOAD_FORMAT = "Compressed and UTF-8 encoded tab delimited file";

    @VisibleForTesting
    public static DataCiteMetadata convert(DOI doi, String size, String numberRecords, String creatorName, String creatorUserId, Calendar created, List<DatasetOccurrenceDownloadUsage> usedDatasets) {
        Preconditions.checkNotNull(doi, "Custom download DOI required to build valid DataCite metadata");
        Preconditions.checkNotNull(size, "Custom download size required to build valid DataCite metadata");
        Preconditions.checkNotNull(numberRecords, "Custom download record count required to build valid DataCite metadata");
        Preconditions.checkNotNull(creatorName, "Custom download creator required to build valid DataCite metadata");
        Preconditions.checkNotNull(creatorUserId, "Custom download creator ID required to build valid DataCite metadata");
        Preconditions.checkNotNull(created, "Custom download created date required to build valid DataCite metadata");
        Preconditions.checkArgument(usedDatasets.size() > 0, "Used datasets required to build valid DataCite metadata");
        DataCiteMetadata.Builder<Void> b = DataCiteMetadata.builder().withIdentifier().withIdentifierType(IdentifierType.DOI.name()).withValue(doi.getDoiName()).end().withTitles().withTitle(DataCiteMetadata.Titles.Title.builder().withValue(CUSTOM_DOWNLOAD_TITLE).build()).end().withSubjects().addSubject().withValue("GBIF").withLang(DataCiteConverter.ENGLISH).end().addSubject().withValue("biodiversity").withLang(DataCiteConverter.ENGLISH).end().addSubject().withValue("species occurrences").withLang(DataCiteConverter.ENGLISH).end().end().withCreators().addCreator().withCreatorName(creatorName).withNameIdentifier(DataCiteConverter.userIdToCreatorNameIdentifier(creatorUserId)).end().end().withPublisher("The Global Biodiversity Information Facility").withPublicationYear(String.valueOf(created.get(1))).withResourceType().withResourceTypeGeneral(ResourceType.DATASET).end().withDates().addDate().withDateType(DateType.CREATED).withValue(DateFormatUtils.ISO_DATE_FORMAT.format(created)).end().addDate().withDateType(DateType.UPDATED).withValue(DateFormatUtils.ISO_DATE_FORMAT.format(created)).end().end().withFormats().addFormat(DOWNLOAD_FORMAT).end().withSizes().addSize(size).end();
        b.withRightsList().addRights().withRightsURI(DataCiteConverter.DEFAULT_DOWNLOAD_LICENSE.getLicenseUrl()).withValue(DataCiteConverter.DEFAULT_DOWNLOAD_LICENSE.getLicenseTitle()).end();
        DataCiteMetadata.Descriptions.Description.Builder<DataCiteMetadata.Descriptions.Builder<DataCiteMetadata.Builder<Void>>> db = b.withDescriptions().addDescription().withDescriptionType(DescriptionType.ABSTRACT).withLang(DataCiteConverter.ENGLISH).addContent(new Serializable[]{String.format("A custom GBIF download containing %s records derived from %s datasets:\n", numberRecords, usedDatasets.size())});
        if (!usedDatasets.isEmpty()) {
            DataCiteMetadata.RelatedIdentifiers.Builder<DataCiteMetadata.Builder<Void>> relBuilder = b.withRelatedIdentifiers();
            for (DatasetOccurrenceDownloadUsage du : usedDatasets) {
                if (du.getDatasetDOI() != null) {
                    relBuilder.addRelatedIdentifier().withRelationType(RelationType.IS_DERIVED_FROM).withValue(du.getDatasetDOI().getDoiName()).withRelatedIdentifierType(RelatedIdentifierType.DOI).end();
                }
                if (Strings.isNullOrEmpty(du.getDatasetTitle())) continue;
                db.addContent(new Serializable[]{String.format("%s records from %s. %s\n", du.getNumberRecords(), du.getDatasetTitle(), du.getDatasetDOI().getUrl())});
            }
            db.addContent(new Serializable[]{"Data from some individual datasets included in this download may be licensed under less restrictive terms."});
        }
        return b.build();
    }
}

