/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.parsing;

import java.util.Properties;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;

public class PropertyParser {
    public static String parse(String string, Properties variables) {
        VariableTokenHandler handler = new VariableTokenHandler(variables);
        GenericTokenParser parser = new GenericTokenParser("${", "}", handler);
        return parser.parse(string);
    }

    private static class VariableTokenHandler
    implements TokenHandler {
        private Properties variables;

        public VariableTokenHandler(Properties variables) {
            this.variables = variables;
        }

        @Override
        public String handleToken(String content) {
            if (this.variables != null && this.variables.containsKey(content)) {
                return this.variables.getProperty(content);
            }
            return "${" + content + "}";
        }
    }
}

