/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.date;

import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.gbif.common.parsers.core.ParseResult;
import org.gbif.common.parsers.date.DateFormatHint;
import org.gbif.common.parsers.date.DatePartsNormalizer;
import org.gbif.common.parsers.date.TemporalParser;
import org.gbif.common.parsers.date.TextualMonthDateTokenizer;
import org.gbif.common.parsers.date.ThreeTenNumericalDateParser;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.LocalDate;
import org.threeten.bp.temporal.TemporalAccessor;

class TextDateParser
implements TemporalParser {
    private static final Pattern NUMERICAL_DATE_PATTERN = Pattern.compile("[^a-zA-Z]+[\\dT\\d]?[^a-zA-Z]+[Z]?$");
    private static final TextualMonthDateTokenizer TEXT_MONTH_TOKENIZER = TextualMonthDateTokenizer.newInstance();
    private static final TemporalParser NUMERICAL_DATE_PARSER = ThreeTenNumericalDateParser.newInstance();
    private static final DatePartsNormalizer DATE_PARTS_NORMALIZER = DatePartsNormalizer.newInstance();

    TextDateParser() {
    }

    @Override
    public ParseResult<TemporalAccessor> parse(String input) {
        DatePartsNormalizer.NormalizedYearMonthDay normalizedYearMonthDay;
        if (StringUtils.isBlank(input)) {
            return ParseResult.fail();
        }
        if (NUMERICAL_DATE_PATTERN.matcher(input).matches()) {
            return NUMERICAL_DATE_PARSER.parse(input, DateFormatHint.NONE);
        }
        TextualMonthDateTokenizer.DateTokens dt = TEXT_MONTH_TOKENIZER.tokenize(input);
        if (!dt.containsDiscardedTokens() && dt.size() == 3 && (normalizedYearMonthDay = DATE_PARTS_NORMALIZER.normalize(dt.getToken(TextualMonthDateTokenizer.TokenType.INT_4).getToken(), dt.getToken(TextualMonthDateTokenizer.TokenType.TEXT).getToken(), dt.getToken(TextualMonthDateTokenizer.TokenType.INT_2).getToken())).getYear() != null && normalizedYearMonthDay.getMonth() != null && normalizedYearMonthDay.getDay() != null) {
            try {
                return ParseResult.success(ParseResult.CONFIDENCE.DEFINITE, LocalDate.of((int)normalizedYearMonthDay.getYear(), (int)normalizedYearMonthDay.getMonth(), (int)normalizedYearMonthDay.getDay()));
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        return ParseResult.fail();
    }

    @Override
    public ParseResult<TemporalAccessor> parse(String input, @Nullable DateFormatHint hint) {
        return NUMERICAL_DATE_PARSER.parse(input, hint);
    }

    @Override
    public ParseResult<TemporalAccessor> parse(String year, String month, String day) {
        DatePartsNormalizer.NormalizedYearMonthDay normalizedYearMonthDay = DATE_PARTS_NORMALIZER.normalize(year, month, day);
        ParseResult<TemporalAccessor> parseResult = NUMERICAL_DATE_PARSER.parse(normalizedYearMonthDay.getYear(), normalizedYearMonthDay.getMonth(), normalizedYearMonthDay.getDay());
        if (parseResult.isSuccessful() && normalizedYearMonthDay.containsDiscardedPart()) {
            return ParseResult.success(ParseResult.CONFIDENCE.PROBABLE, parseResult.getPayload());
        }
        return parseResult;
    }

    @Override
    public ParseResult<TemporalAccessor> parse(@Nullable Integer year, @Nullable Integer month, @Nullable Integer day) {
        return NUMERICAL_DATE_PARSER.parse(year, month, day);
    }
}

