/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.date;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.gbif.utils.file.csv.CSVReader;
import org.gbif.utils.file.csv.CSVReaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Month;

public class DatePartsNormalizer {
    private static final Logger LOG = LoggerFactory.getLogger(DatePartsNormalizer.class);
    private static final String STRING_NULL = "\\N";
    private static final String COLUMN_SEPARATOR = ";";
    private static final Splitter ROW_ELEMENT_SPLITTER = Splitter.on(',').trimResults().omitEmptyStrings();
    private static final String COMMENT_MARKER = "#";
    private static final String MONTH_FILEPATH = "/dictionaries/parse/month.csv";
    private static final String[][] MONTHS = new String[Month.values().length][];

    private DatePartsNormalizer() {
    }

    public static DatePartsNormalizer newInstance() {
        return new DatePartsNormalizer();
    }

    public NormalizedYearMonthDay normalize(String year, String month, String day) {
        year = this.normalizeFloat(year);
        month = this.normalizeFloat(month);
        day = this.normalizeFloat(day);
        Integer monthAsInt = this.parseOrNull(month);
        if (monthAsInt == null) {
            monthAsInt = this.monthNameToNumerical(month);
        }
        Integer iYear = this.parseOrNull(year);
        Integer iMonth = monthAsInt;
        Integer iDay = this.parseOrNull(day);
        boolean yearDiscarded = this.wasDiscarded(year, iYear);
        boolean monthDiscarded = this.wasDiscarded(month, iMonth);
        boolean dayDiscarded = this.wasDiscarded(day, iDay);
        return new NormalizedYearMonthDay(iYear, iMonth, iDay, yearDiscarded, monthDiscarded, dayDiscarded);
    }

    public Integer monthNameToNumerical(String month) {
        if (StringUtils.isNotBlank(month)) {
            int m = 1;
            String[][] stringArray = MONTHS;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] monthValues;
                for (String monthVal : monthValues = stringArray[i]) {
                    if (!monthVal.equals(month.toLowerCase()) && !(monthVal + ".").equals(month.toLowerCase())) continue;
                    return m;
                }
                ++m;
            }
        }
        return null;
    }

    public String normalizeFloat(String value) {
        if (value != null && value.contains(".0")) {
            try {
                Double d = new Double(value);
                if ((double)d.intValue() == d) {
                    return String.valueOf(d.intValue());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    private Integer parseOrNull(String integer) {
        if (integer != null) {
            integer = integer.trim();
        }
        try {
            return Integer.valueOf(integer);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private boolean wasDiscarded(String strValue, Integer intValue) {
        if (StringUtils.isBlank(strValue) || STRING_NULL.equals(strValue)) {
            return false;
        }
        return intValue == null;
    }

    static {
        HashMap monthMap = Maps.newHashMapWithExpectedSize(Month.values().length);
        for (Month m : Month.values()) {
            String keyName = m.name().toLowerCase();
            monthMap.put(keyName, new HashSet());
            ((Set)monthMap.get(keyName)).add(keyName);
        }
        InputStream monthFileStream = DatePartsNormalizer.class.getResourceAsStream(MONTH_FILEPATH);
        if (monthFileStream == null) {
            LOG.error("Month file can not be loaded. File not found: {}", (Object)MONTH_FILEPATH);
        } else {
            try {
                CSVReader csv = CSVReaderFactory.build((InputStream)monthFileStream, (String)Charsets.UTF_8.name(), (String)COLUMN_SEPARATOR, null, (Integer)0);
                for (String[] row : csv) {
                    if (row == null || row[0].startsWith(COMMENT_MARKER)) continue;
                    String monthKey = row[0].toLowerCase();
                    if (monthMap.containsKey(monthKey)) {
                        for (String monthAltName : ROW_ELEMENT_SPLITTER.split(row[1])) {
                            ((Set)monthMap.get(monthKey)).add(monthAltName.toLowerCase());
                        }
                        continue;
                    }
                    LOG.error("Unknown month found in: {}", (Object)MONTH_FILEPATH);
                }
            }
            catch (IOException e) {
                LOG.error("Error loading month alternative names", (Throwable)e);
            }
            int index = 0;
            for (Month m : Month.values()) {
                DatePartsNormalizer.MONTHS[index] = ((Set)monthMap.get(m.name().toLowerCase())).toArray(new String[0]);
                ++index;
            }
        }
    }

    public static class NormalizedYearMonthDay {
        private Integer year;
        private Integer month;
        private Integer day;
        private boolean yDiscarded;
        private boolean mDiscarded;
        private boolean dDiscarded;

        NormalizedYearMonthDay(Integer year, Integer month, Integer day, boolean yDiscarded, boolean mDiscarded, boolean dDiscarded) {
            this.year = year;
            this.month = month;
            this.day = day;
            this.yDiscarded = yDiscarded;
            this.mDiscarded = mDiscarded;
            this.dDiscarded = dDiscarded;
        }

        public Integer getYear() {
            return this.year;
        }

        public Integer getMonth() {
            return this.month;
        }

        public Integer getDay() {
            return this.day;
        }

        public boolean yDiscarded() {
            return this.yDiscarded;
        }

        public boolean mDiscarded() {
            return this.mDiscarded;
        }

        public boolean dDiscarded() {
            return this.dDiscarded;
        }

        public boolean containsDiscardedPart() {
            return this.yDiscarded || this.mDiscarded || this.dDiscarded;
        }

        public String toString() {
            return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("year", this.year).append("month", this.month).append("day", this.day).append("yDiscarded", this.yDiscarded).append("mDiscarded", this.mDiscarded).append("dDiscarded", this.dDiscarded).toString();
        }
    }
}

