/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.date;

import com.google.common.base.Joiner;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.gbif.common.parsers.core.ParseResult;
import org.gbif.common.parsers.date.StringToDateParser;
import org.gbif.common.parsers.date.YearMonthDay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DateParseUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateParseUtils.class);
    private static final Joiner DATE_JOINER = Joiner.on("-").skipNulls();
    private static final StringToDateParser STRING_TO_DATE_PARSER = new StringToDateParser();
    protected static final String[][] MONTHS = new String[][]{{"January", "Jan", "J", "Ene", "Ja"}, {"February", "Feb", "F", "Fe"}, {"March", "Mar"}, {"April", "Apr", "Ap", "Abr"}, {"May"}, {"June", "Jun"}, {"July", "Jul"}, {"August", "Aug", "Au", "Ago"}, {"September", "Sep", "Sept", "Set", "S"}, {"October", "Oct", "O", "Oc"}, {"Novermber", "Nov", "N", "No"}, {"December", "Dec", "D", "De"}};
    protected static final int CURRENT_YEAR = new GregorianCalendar().get(1);

    public static ParseResult<Date> parse(String input) {
        input = DateParseUtils.normalizeMonth(input);
        return STRING_TO_DATE_PARSER.parse(input);
    }

    public static ParseResult<Date> parse(String input, String format) {
        try {
            Date d = DateUtils.parseDate(input, format);
            LOGGER.debug("Parsed input[{}] in format[{}] to date[{}]", new Object[]{input, format, d});
            return ParseResult.success(ParseResult.CONFIDENCE.DEFINITE, d);
        }
        catch (ParseException e) {
            LOGGER.debug("Exception caught trying to parse a date", (Throwable)e);
            return ParseResult.fail();
        }
    }

    public static boolean isValidUse(String value, DATE_FIELD field) {
        if (value == null) {
            return false;
        }
        try {
            int valueAsInt = Integer.parseInt(value);
            switch (field) {
                case DAY: {
                    return valueAsInt >= 1 && valueAsInt <= 31;
                }
                case MONTH: {
                    return valueAsInt >= 1 && valueAsInt <= 12;
                }
                case YEAR: {
                    return valueAsInt >= 1 && valueAsInt <= new GregorianCalendar().get(1);
                }
            }
        }
        catch (NumberFormatException e) {
            LOGGER.debug("{} does not appear valid as a {}", (Object)value, (Object)field);
        }
        return false;
    }

    public static boolean isDateCoercible(YearMonthDay ymd) {
        if (ymd.getYear() == null || ymd.getMonth() == null || ymd.getDay() == null) {
            return true;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setLenient(false);
        return sdf.parse(DATE_JOINER.join(ymd.getYear(), ymd.getMonth(), ymd.getDay()), new ParsePosition(0)) != null;
    }

    public static ParseResult<Date> parse(@Nullable String year, @Nullable String month, @Nullable String day) {
        if (year == null && month == null && day == null) {
            return ParseResult.fail();
        }
        month = DateParseUtils.normalizeMonth(month);
        Date d = STRING_TO_DATE_PARSER.strictParse(day + "/" + month + "/" + year, "dd/MM/yyyy", "dd/mm/yyyy");
        if (d != null) {
            return ParseResult.success(ParseResult.CONFIDENCE.DEFINITE, d);
        }
        return ParseResult.fail();
    }

    public static YearMonthDay atomize(Date input) {
        YearMonthDay ymd = new YearMonthDay();
        Calendar c = Calendar.getInstance();
        c.setTime(input);
        ymd.setDay(String.valueOf(c.get(5)));
        ymd.setMonth(String.valueOf(c.get(2) + 1));
        ymd.setYear(String.valueOf(c.get(1)));
        return ymd;
    }

    public static YearMonthDay normalize(String year, String month, String day) {
        YearMonthDay ymd = new YearMonthDay();
        year = DateParseUtils.normalizeFloat(year);
        month = DateParseUtils.normalizeFloat(month);
        day = DateParseUtils.normalizeFloat(day);
        month = DateParseUtils.normalizeMonth(month);
        day = "\\N".equalsIgnoreCase(day) ? null : day;
        month = "\\N".equalsIgnoreCase(month) ? null : month;
        year = "\\N".equalsIgnoreCase(year) ? null : year;
        if (DateParseUtils.isValidUse(year = DateParseUtils.inferCentury(year), DATE_FIELD.YEAR)) {
            ymd.setYear(year);
        }
        if (DateParseUtils.isValidUse(month, DATE_FIELD.MONTH)) {
            ymd.setMonth(month);
        }
        if (DateParseUtils.isValidUse(day, DATE_FIELD.DAY)) {
            ymd.setDay(day);
        }
        if (ymd.representsNull() && StringUtils.isNotBlank(year)) {
            LOGGER.debug("Attempting to infer day, month and year from year field: {}", (Object)year);
            ParseResult<YearMonthDay> result = DateParseUtils.atomize(year);
            if (ParseResult.STATUS.SUCCESS == result.getStatus()) {
                LOGGER.debug("Year[{}] resulted in: {}", (Object)year, (Object)result.getPayload());
                ymd = result.getPayload();
            } else {
                try {
                    Date p = DateUtils.parseDate(year, "yyyy-MM-dd", "yyyy/MM/dd");
                    GregorianCalendar gc = new GregorianCalendar();
                    gc.setTime(p);
                    ymd.setYear(String.valueOf(gc.get(1)));
                    ymd.setMonth(String.valueOf(1 + gc.get(2)));
                    ymd.setDay(String.valueOf(gc.get(5)));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        if (!DateParseUtils.isDateCoercible(ymd)) {
            ymd.setYear(null);
            ymd.setMonth(null);
            ymd.setDay(null);
        }
        if (!DateParseUtils.isValidUse(ymd.getYear(), DATE_FIELD.YEAR)) {
            ymd.setYear(null);
        }
        if (!DateParseUtils.isValidUse(ymd.getMonth(), DATE_FIELD.MONTH)) {
            ymd.setMonth(null);
        }
        if (!DateParseUtils.isValidUse(ymd.getDay(), DATE_FIELD.DAY)) {
            ymd.setDay(null);
        }
        return ymd;
    }

    public static String inferCentury(String year) {
        try {
            int y = Integer.parseInt(year);
            if (y >= 0 && y <= 99) {
                y = CURRENT_YEAR - CURRENT_YEAR % 100 + y > CURRENT_YEAR ? CURRENT_YEAR - CURRENT_YEAR % 100 - 100 + y : CURRENT_YEAR - CURRENT_YEAR % 100 + y;
                return String.valueOf(y);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return year;
    }

    public static String normalizeFloat(String value) {
        if (value != null && value.contains(".0")) {
            try {
                Double d = new Double(value);
                if ((double)d.intValue() == d) {
                    return String.valueOf(d.intValue());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public static ParseResult<YearMonthDay> atomize(String input) {
        ParseResult<Date> parsed = DateParseUtils.parse(input = DateParseUtils.normalizeMonth(input));
        if (ParseResult.STATUS.SUCCESS == parsed.getStatus()) {
            YearMonthDay atomized = DateParseUtils.atomize(parsed.getPayload());
            return ParseResult.success(parsed.getConfidence(), atomized);
        }
        if (ParseResult.STATUS.ERROR == parsed.getStatus()) {
            return ParseResult.error(parsed.getError());
        }
        return ParseResult.fail();
    }

    public static String normalizeMonth(String input) {
        if (input != null) {
            int m = 1;
            String[][] stringArray = MONTHS;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] monthValues;
                for (String month : monthValues = stringArray[i]) {
                    if (!StringUtils.equalsIgnoreCase(month, input) && !StringUtils.equalsIgnoreCase(month + ".", input)) continue;
                    return DateParseUtils.padTo2Chars(m);
                }
                ++m;
            }
        }
        return input;
    }

    protected static String padTo2Chars(int value) {
        return value < 10 ? "0" + value : String.valueOf(value);
    }

    public static enum DATE_FIELD {
        DAY,
        MONTH,
        YEAR;

    }
}

