/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.date;

import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalField;

public class AtomizedLocalDate {
    private final Integer year;
    private final Integer month;
    private final Integer day;
    private final int resolution;

    private AtomizedLocalDate(Integer year, Integer month, Integer day) {
        this.year = year;
        this.month = month;
        this.day = day;
        int res = 0;
        if (year != null) {
            ++res;
        }
        if (month != null) {
            ++res;
        }
        if (day != null) {
            ++res;
        }
        this.resolution = res;
    }

    public static AtomizedLocalDate fromTemporalAccessor(TemporalAccessor temporalAccessor) {
        if (temporalAccessor == null) {
            return null;
        }
        Integer y = null;
        Integer m = null;
        Integer d = null;
        if (temporalAccessor.isSupported((TemporalField)ChronoField.YEAR)) {
            y = temporalAccessor.get((TemporalField)ChronoField.YEAR);
        }
        if (temporalAccessor.isSupported((TemporalField)ChronoField.MONTH_OF_YEAR)) {
            m = temporalAccessor.get((TemporalField)ChronoField.MONTH_OF_YEAR);
        }
        if (temporalAccessor.isSupported((TemporalField)ChronoField.DAY_OF_MONTH)) {
            d = temporalAccessor.get((TemporalField)ChronoField.DAY_OF_MONTH);
        }
        return new AtomizedLocalDate(y, m, d);
    }

    public Integer getYear() {
        return this.year;
    }

    public Integer getMonth() {
        return this.month;
    }

    public Integer getDay() {
        return this.day;
    }

    public int getResolution() {
        return this.resolution;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.year).append(this.month).append(this.day).append(this.resolution).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AtomizedLocalDate)) {
            return false;
        }
        AtomizedLocalDate that = (AtomizedLocalDate)obj;
        return Objects.equal(this.year, that.year) && Objects.equal(this.month, that.month) && Objects.equal(this.day, that.day) && Objects.equal(this.resolution, that.resolution);
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("year", this.year).append("month", this.month).append("day", this.day).append("resolution", this.resolution).toString();
    }
}

