/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.core;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ParseResult<T> {
    protected STATUS status;
    protected CONFIDENCE confidence;
    protected T payload;
    protected Throwable error;

    public static <T1> ParseResult<T1> success(CONFIDENCE confidence, T1 payload) {
        return new ParseResult<T1>(STATUS.SUCCESS, confidence, payload, null);
    }

    public static <T1> ParseResult<T1> fail() {
        return new ParseResult<Object>(STATUS.FAIL, null, null, null);
    }

    public static <T1> ParseResult<T1> error() {
        return new ParseResult<Object>(STATUS.ERROR, null, null, null);
    }

    public static <T1> ParseResult<T1> error(Throwable cause) {
        return new ParseResult<Object>(STATUS.ERROR, null, null, cause);
    }

    public ParseResult(STATUS status, CONFIDENCE confidence, T payload, Throwable error) {
        this.status = status;
        this.confidence = confidence;
        this.payload = payload;
        this.error = error;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public CONFIDENCE getConfidence() {
        return this.confidence;
    }

    public T getPayload() {
        return this.payload;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean isSuccessful() {
        return this.status == STATUS.SUCCESS;
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("status", (Object)this.getStatus()).append("confidence", (Object)this.getConfidence()).append("payload", this.getPayload()).append("error", this.getError()).toString();
    }

    public static enum CONFIDENCE {
        DEFINITE,
        PROBABLE,
        POSSIBLE;

    }

    public static enum STATUS {
        SUCCESS,
        FAIL,
        ERROR;

    }
}

