/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.core;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.gbif.api.vocabulary.OccurrenceIssue;
import org.gbif.common.parsers.core.ParseResult;

public class OccurrenceParseResult<T>
extends ParseResult<T> {
    private final Set<OccurrenceIssue> issues = EnumSet.noneOf(OccurrenceIssue.class);

    public OccurrenceParseResult(ParseResult.STATUS status, ParseResult.CONFIDENCE confidence, T payload, Throwable error, Collection<OccurrenceIssue> issues) {
        super(status, confidence, payload, error);
        if (issues != null) {
            Iterables.addAll(this.issues, Iterables.filter(issues, Predicates.notNull()));
        }
    }

    public OccurrenceParseResult(ParseResult.STATUS status, ParseResult.CONFIDENCE confidence, T payload, Throwable error) {
        super(status, confidence, payload, error);
    }

    public OccurrenceParseResult(ParseResult<T> result) {
        super(result.getStatus(), result.getConfidence(), result.getPayload(), result.getError());
    }

    public static <T> OccurrenceParseResult<T> success(ParseResult.CONFIDENCE confidence, T payload) {
        return new OccurrenceParseResult<T>(ParseResult.STATUS.SUCCESS, confidence, payload, null);
    }

    public static <T> OccurrenceParseResult<T> fail() {
        return new OccurrenceParseResult<Object>(ParseResult.STATUS.FAIL, null, null, null);
    }

    public static <T> OccurrenceParseResult<T> error() {
        return new OccurrenceParseResult<Object>(ParseResult.STATUS.ERROR, null, null, null);
    }

    public static <T> OccurrenceParseResult<T> error(Throwable cause) {
        return new OccurrenceParseResult<Object>(ParseResult.STATUS.ERROR, null, null, cause);
    }

    public static <T> OccurrenceParseResult<T> success(ParseResult.CONFIDENCE confidence, T payload, OccurrenceIssue issue) {
        return new OccurrenceParseResult<T>(ParseResult.STATUS.SUCCESS, confidence, payload, null, Lists.newArrayList(issue));
    }

    public static <T> OccurrenceParseResult<T> success(ParseResult.CONFIDENCE confidence, T payload, OccurrenceIssue ... issues) {
        return new OccurrenceParseResult<T>(ParseResult.STATUS.SUCCESS, confidence, payload, null, Lists.newArrayList(issues));
    }

    public static <T> OccurrenceParseResult<T> success(ParseResult.CONFIDENCE confidence, T payload, Collection<OccurrenceIssue> issues) {
        return new OccurrenceParseResult<T>(ParseResult.STATUS.SUCCESS, confidence, payload, null, issues);
    }

    public static <T> OccurrenceParseResult<T> fail(OccurrenceIssue issue) {
        return new OccurrenceParseResult<Object>(ParseResult.STATUS.FAIL, null, null, null, Lists.newArrayList(issue));
    }

    public static <T> OccurrenceParseResult<T> fail(OccurrenceIssue ... issues) {
        return new OccurrenceParseResult<Object>(ParseResult.STATUS.FAIL, null, null, null, Lists.newArrayList(issues));
    }

    public static <T> OccurrenceParseResult<T> fail(Collection<OccurrenceIssue> issues) {
        return new OccurrenceParseResult<Object>(ParseResult.STATUS.FAIL, null, null, null, issues);
    }

    public static <T> OccurrenceParseResult<T> fail(T payload, Collection<OccurrenceIssue> issues) {
        return new OccurrenceParseResult<T>(ParseResult.STATUS.FAIL, null, payload, null, issues);
    }

    public static <T> OccurrenceParseResult<T> fail(T payload, OccurrenceIssue ... issues) {
        return new OccurrenceParseResult<T>(ParseResult.STATUS.FAIL, null, payload, null, Lists.newArrayList(issues));
    }

    public static <T> OccurrenceParseResult<T> fail(T payload, OccurrenceIssue issue) {
        return new OccurrenceParseResult<T>(ParseResult.STATUS.FAIL, null, payload, null, Lists.newArrayList(issue));
    }

    public Set<OccurrenceIssue> getIssues() {
        return this.issues;
    }

    public void addIssue(OccurrenceIssue issue) {
        Preconditions.checkNotNull(issue);
        this.issues.add(issue);
    }
}

