/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.core;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gbif.common.parsers.core.KeyValue;
import org.gbif.common.parsers.core.Parsable;
import org.gbif.common.parsers.core.ParseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryBackedParser<V>
implements Parsable<V> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, V> dictionary = new HashMap<String, V>();
    private boolean caseSensitive = false;

    public DictionaryBackedParser(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void init(Iterator<KeyValue<String, V>> source) {
        while (source.hasNext()) {
            KeyValue<String, V> kvp = source.next();
            this.add(kvp.getKey(), kvp.getValue());
        }
    }

    protected final void add(String key, V value) {
        String normedKey;
        if (!StringUtils.isBlank(key) && !Strings.isNullOrEmpty(normedKey = this.normalize(key))) {
            V existingValue = this.dictionary.get(normedKey);
            if (existingValue == null) {
                this.dictionary.put(normedKey, value);
            } else if (!existingValue.equals(value)) {
                this.log.warn("Ignoring mapping {}\u2192{} as {} is already mapped to {}", new Object[]{key, value, key, existingValue});
            }
        }
    }

    protected String normalize(String value) {
        if (value != null) {
            if (!this.caseSensitive) {
                return StringUtils.trimToNull(value.toUpperCase());
            }
            return StringUtils.trimToNull(value);
        }
        return value;
    }

    @Override
    public ParseResult<V> parse(String input) {
        String normed = this.normalize(input);
        V value = this.dictionary.get(normed);
        if (value == null) {
            return ParseResult.fail();
        }
        return ParseResult.success(ParseResult.CONFIDENCE.DEFINITE, value);
    }
}

