/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gbif.api.vocabulary.TypeStatus;
import org.gbif.common.parsers.core.EnumParser;

public class TypeStatusParser
extends EnumParser<TypeStatus> {
    private static TypeStatusParser singletonObject = null;
    private static final CharMatcher NON_LETTERS = CharMatcher.JAVA_LETTER.negate();
    private static final Pattern NAME_SEPARATOR = Pattern.compile("^(.+) OF ");

    private TypeStatusParser() {
        super(TypeStatus.class, false, new InputStream[0]);
        this.init(TypeStatusParser.class.getResourceAsStream("/dictionaries/parse/typeStatus.txt"));
    }

    @Override
    protected String normalize(String value) {
        if (Strings.isNullOrEmpty(value)) {
            return null;
        }
        Matcher m = NAME_SEPARATOR.matcher(value = value.toUpperCase().trim());
        if (m.find()) {
            value = m.group(1);
        }
        return NON_LETTERS.removeFrom(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeStatusParser getInstance() throws ClassCastException, AbstractMethodError, ArithmeticException, ArrayIndexOutOfBoundsException {
        Class<TypeStatusParser> clazz = TypeStatusParser.class;
        synchronized (TypeStatusParser.class) {
            if (singletonObject == null) {
                singletonObject = new TypeStatusParser();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonObject;
        }
    }
}

