/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Pattern;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.gbif.common.parsers.core.EnumParser;
import org.gbif.common.parsers.core.ParseResult;

public class NomStatusParser
extends EnumParser<NomenclaturalStatus> {
    private Pattern CLEAN_PREFIX = Pattern.compile("\\s*\\.?\\s*");
    private Map<String, NomenclaturalStatus> PREFIXES = ImmutableMap.builder().put("nom illeg", NomenclaturalStatus.ILLEGITIMATE).put("nom inval", NomenclaturalStatus.INVALID).put("comb nov", NomenclaturalStatus.NEW_COMBINATION).put("nom nov", NomenclaturalStatus.REPLACEMENT).put("nom nud", NomenclaturalStatus.NUDUM).put("nom rej", NomenclaturalStatus.REJECTED).put("unavailable", NomenclaturalStatus.INVALID).build();
    private static NomStatusParser singletonObject = null;

    private NomStatusParser(InputStream ... file) {
        super(NomenclaturalStatus.class, false, file);
        for (NomenclaturalStatus ns : NomenclaturalStatus.values()) {
            this.add(ns.getLatinLabel(), ns);
            this.add(ns.getAbbreviatedLabel(), ns);
        }
    }

    @Override
    public ParseResult<NomenclaturalStatus> parse(String input) {
        String normed;
        ParseResult<NomenclaturalStatus> result = super.parse(input);
        if (!(result.isSuccessful() || Strings.isNullOrEmpty(input) || Strings.isNullOrEmpty(normed = this.CLEAN_PREFIX.matcher(input).replaceFirst(" ").trim().toLowerCase()))) {
            for (Map.Entry<String, NomenclaturalStatus> entry : this.PREFIXES.entrySet()) {
                if (!normed.startsWith(entry.getKey())) continue;
                return ParseResult.success(ParseResult.CONFIDENCE.PROBABLE, entry.getValue());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NomStatusParser getInstance() throws ClassCastException, AbstractMethodError, ArithmeticException, ArrayIndexOutOfBoundsException {
        Class<NomStatusParser> clazz = NomStatusParser.class;
        synchronized (NomStatusParser.class) {
            if (singletonObject == null) {
                singletonObject = new NomStatusParser(NomStatusParser.class.getResourceAsStream("/dictionaries/parse/nomStatus.txt"));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonObject;
        }
    }
}

