/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.serializer;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.BeanDescription;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.TypeSerializer;
import org.codehaus.jackson.map.type.MapLikeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultimapSerializer
extends JsonSerializer<Multimap<?, ?>> {
    private final BeanProperty property;
    private final JsonSerializer<Object> keySerializer;
    private final TypeSerializer elementTypeSerializer;
    private final JsonSerializer<Object> elementValueSerializer;

    public MultimapSerializer(SerializationConfig config, MapLikeType type, BeanDescription beanDesc, BeanProperty property, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        this.property = property;
        this.keySerializer = keySerializer;
        this.elementTypeSerializer = elementTypeSerializer;
        this.elementValueSerializer = elementValueSerializer;
    }

    public void serialize(Multimap<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (this.elementTypeSerializer == null) {
            jgen.writeStartObject();
        } else {
            this.elementTypeSerializer.writeTypePrefixForObject(value, jgen);
        }
        for (Map.Entry e : value.asMap().entrySet()) {
            if (this.keySerializer != null) {
                this.keySerializer.serialize(e.getKey(), jgen, provider);
            } else {
                provider.findKeySerializer(provider.constructType(String.class), this.property).serialize(e.getKey(), jgen, provider);
            }
            if (this.elementValueSerializer != null) {
                this.elementValueSerializer.serialize(e.getValue(), jgen, provider);
                continue;
            }
            provider.defaultSerializeValue((Object)Lists.newArrayList((Iterable)((Iterable)e.getValue())), jgen);
        }
        if (this.elementTypeSerializer == null) {
            jgen.writeEndObject();
        } else {
            this.elementTypeSerializer.writeTypeSuffixForObject(value, jgen);
        }
    }
}

