/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.deser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.BeanDescription;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.type.MapLikeType;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultimapDeserializer
extends JsonDeserializer<Multimap<?, ?>> {
    private static final List<Class<?>> KNOWN_IMPLEMENTATIONS = ImmutableList.of(ImmutableListMultimap.class, ImmutableSetMultimap.class, ImmutableMultimap.class);
    private static final List<String> METHOD_NAMES = ImmutableList.of((Object)"create", (Object)"copyOf");
    private final MapLikeType type;
    private final KeyDeserializer keyDeserializer;
    private final TypeDeserializer elementTypeDeserializer;
    private final JsonDeserializer<?> elementDeserializer;

    public MultimapDeserializer(MapLikeType type, DeserializationConfig config, DeserializerProvider provider, BeanDescription beanDesc, BeanProperty property, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        JavaType keyType = type.getKeyType();
        JavaType valueType = type.getContentType();
        this.type = type;
        this.keyDeserializer = keyDeserializer == null ? provider.findKeyDeserializer(config, keyType, property) : keyDeserializer;
        this.elementTypeDeserializer = elementTypeDeserializer;
        this.elementDeserializer = elementDeserializer == null ? provider.findValueDeserializer(config, valueType, property) : elementDeserializer;
    }

    public Multimap<?, ?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        LinkedListMultimap builder = LinkedListMultimap.create();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            Object key = this.keyDeserializer != null ? this.keyDeserializer.deserializeKey(jp.getCurrentName(), ctxt) : jp.getCurrentName();
            jp.nextToken();
            this.expect(jp, JsonToken.START_ARRAY);
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                if (this.elementTypeDeserializer != null) {
                    builder.put(key, this.elementDeserializer.deserializeWithType(jp, ctxt, this.elementTypeDeserializer));
                    continue;
                }
                builder.put(key, this.elementDeserializer.deserialize(jp, ctxt));
            }
        }
        return this.transform(this.type.getRawClass(), (Multimap<Object, Object>)builder);
    }

    private Multimap<?, ?> transform(Class<?> rawClass, Multimap<Object, Object> map) throws JsonMappingException {
        LinkedList classesToTry = Lists.newLinkedList(KNOWN_IMPLEMENTATIONS);
        classesToTry.addFirst(rawClass);
        for (Class klass : classesToTry) {
            for (String methodName : METHOD_NAMES) {
                try {
                    Method m = klass.getMethod(methodName, Multimap.class);
                    return (Multimap)m.invoke(null, map);
                }
                catch (SecurityException e) {
                    throw new JsonMappingException("Could not map to " + klass, (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    throw new JsonMappingException("Could not map to " + klass, (Throwable)e);
                }
            }
        }
        return map;
    }

    private void expect(JsonParser jp, JsonToken token) throws IOException {
        if (jp.getCurrentToken() != token) {
            throw new JsonMappingException("Expecting " + token + ", found " + jp.getCurrentToken(), jp.getCurrentLocation());
        }
    }
}

