/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.deser;

import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.type.MapType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GuavaMapDeserializer<T>
extends JsonDeserializer<T> {
    protected final MapType _mapType;
    protected final KeyDeserializer _keyDeserializer;
    protected final JsonDeserializer<?> _valueDeserializer;
    protected final TypeDeserializer _typeDeserializerForValue;

    protected GuavaMapDeserializer(MapType type, KeyDeserializer keyDeser, TypeDeserializer typeDeser, JsonDeserializer<?> deser) {
        this._mapType = type;
        this._keyDeserializer = keyDeser;
        this._typeDeserializerForValue = typeDeser;
        this._valueDeserializer = deser;
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromArray(jp, ctxt);
    }

    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT ? (t = jp.nextToken()) != JsonToken.FIELD_NAME && t != JsonToken.END_OBJECT : t != JsonToken.FIELD_NAME) {
            throw ctxt.mappingException(this._mapType.getRawClass());
        }
        return this._deserializeEntries(jp, ctxt);
    }

    protected abstract T _deserializeEntries(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;
}

