/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava;

import com.fasterxml.jackson.datatype.guava.deser.GuavaOptionalDeserializer;
import com.fasterxml.jackson.datatype.guava.deser.HashMultisetDeserializer;
import com.fasterxml.jackson.datatype.guava.deser.ImmutableListDeserializer;
import com.fasterxml.jackson.datatype.guava.deser.ImmutableMapDeserializer;
import com.fasterxml.jackson.datatype.guava.deser.ImmutableSetDeserializer;
import com.fasterxml.jackson.datatype.guava.deser.ImmutableSortedSetDeserializer;
import com.fasterxml.jackson.datatype.guava.deser.MultimapDeserializer;
import com.google.common.base.Optional;
import com.google.common.collect.EnumMultiset;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import org.codehaus.jackson.map.BeanDescription;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.Deserializers;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.MapLikeType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuavaDeserializers
extends Deserializers.Base {
    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, DeserializerProvider provider, BeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
        Class raw = type.getRawClass();
        if (Optional.class.isAssignableFrom(raw)) {
            JavaType referenceType = type.containedType(0);
            return new GuavaOptionalDeserializer(type, provider.findTypedValueDeserializer(config, referenceType, property));
        }
        return super.findBeanDeserializer(type, config, provider, beanDesc, property);
    }

    public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, DeserializerProvider provider, BeanDescription beanDesc, BeanProperty property, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class raw = type.getRawClass();
        if (Multiset.class.isAssignableFrom(raw)) {
            if (LinkedHashMultiset.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (HashMultiset.class.isAssignableFrom(raw)) {
                return new HashMultisetDeserializer(type, elementTypeDeserializer, this._verifyElementDeserializer(elementDeserializer, config, provider, property, (JavaType)type));
            }
            if (ImmutableMultiset.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (EnumMultiset.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (TreeMultiset.class.isAssignableFrom(raw)) {
                // empty if block
            }
            return new HashMultisetDeserializer(type, elementTypeDeserializer, this._verifyElementDeserializer(elementDeserializer, config, provider, property, (JavaType)type));
        }
        if (ImmutableCollection.class.isAssignableFrom(raw)) {
            if (ImmutableList.class.isAssignableFrom(raw)) {
                return new ImmutableListDeserializer(type, elementTypeDeserializer, this._verifyElementDeserializer(elementDeserializer, config, provider, property, (JavaType)type));
            }
            if (ImmutableSet.class.isAssignableFrom(raw)) {
                if (ImmutableSortedSet.class.isAssignableFrom(raw)) {
                    Class elemType = type.getContentType().getRawClass();
                    if (!Comparable.class.isAssignableFrom(elemType)) {
                        throw new IllegalArgumentException("Can not handle ImmutableSortedSet with elements that are not Comparable<?> (" + raw.getName() + ")");
                    }
                    return new ImmutableSortedSetDeserializer(type, elementTypeDeserializer, this._verifyElementDeserializer(elementDeserializer, config, provider, property, (JavaType)type));
                }
                return new ImmutableSetDeserializer(type, elementTypeDeserializer, this._verifyElementDeserializer(elementDeserializer, config, provider, property, (JavaType)type));
            }
        }
        return null;
    }

    public JsonDeserializer<?> findMapDeserializer(MapType type, DeserializationConfig config, DeserializerProvider provider, BeanDescription beanDesc, BeanProperty property, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class raw = type.getRawClass();
        if (ImmutableMap.class.isAssignableFrom(raw)) {
            if (ImmutableSortedMap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (ImmutableBiMap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            return new ImmutableMapDeserializer(type, keyDeserializer, elementTypeDeserializer, this._verifyElementDeserializer(elementDeserializer, config, provider, property, (JavaType)type));
        }
        return null;
    }

    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType type, DeserializationConfig config, DeserializerProvider provider, BeanDescription beanDesc, BeanProperty property, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        if (Multimap.class.isAssignableFrom(type.getRawClass())) {
            return new MultimapDeserializer(type, config, provider, beanDesc, property, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        return null;
    }

    protected JsonDeserializer<?> _verifyElementDeserializer(JsonDeserializer<?> deser, DeserializationConfig config, DeserializerProvider provider, BeanProperty prop, JavaType type) throws JsonMappingException {
        if (deser == null) {
            deser = provider.findValueDeserializer(config, type.getContentType(), prop);
        }
        return deser;
    }
}

