/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config.generator;

import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.generator.ConfigurationGenerator;
import net.sf.ehcache.config.generator.ConfigurationSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationUtil {
    public static String generateConfigurationTextFromSource(ConfigurationSource configSource) {
        if (configSource == null) {
            throw new AssertionError((Object)"ConfigSource cannot be null");
        }
        Configuration config = configSource.createConfiguration();
        return ConfigurationUtil.generateConfigurationText(config, config.getDefaultCacheConfiguration(), config.getCacheConfigurations());
    }

    public static String generateConfigurationTextFromConfiguration(CacheManager cacheManager, Configuration configuration) {
        if (configuration == null) {
            throw new AssertionError((Object)"Confuguration cannot be null");
        }
        if (cacheManager == null) {
            throw new AssertionError((Object)"CacheManager cannot be null");
        }
        Map<String, CacheConfiguration> cacheConfigs = configuration.getCacheConfigurations();
        for (String name : cacheManager.getCacheNames()) {
            Cache cache = cacheManager.getCache(name);
            if (cache == null) continue;
            cacheConfigs.put(cache.getCacheConfiguration().getName(), cache.getCacheConfiguration());
        }
        return ConfigurationUtil.generateConfigurationText(configuration, configuration.getDefaultCacheConfiguration(), cacheConfigs);
    }

    private static String generateConfigurationText(Configuration configuration, CacheConfiguration defaultCacheConfiguration, Map<String, CacheConfiguration> cacheConfigs) {
        return new ConfigurationGenerator().generate(configuration, defaultCacheConfiguration, cacheConfigs);
    }

    public static String generateConfigurationTextForCacheFromSource(ConfigurationSource configSource, String cacheName) {
        if (configSource == null) {
            throw new AssertionError((Object)"ConfigSource cannot be null");
        }
        Configuration config = configSource.createConfiguration();
        CacheConfiguration cacheConfig = config.getCacheConfigurations().get(cacheName);
        if (cacheConfig == null) {
            return "";
        }
        return new ConfigurationGenerator().generate(cacheConfig);
    }

    public static String generateConfigurationTextForCache(CacheManager cacheManager, String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            return "";
        }
        return new ConfigurationGenerator().generate(cache.getCacheConfiguration());
    }
}

