/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.file.tabular;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.gbif.common.shaded.com.fasterxml.jackson.databind.MappingIterator;
import org.gbif.common.shaded.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.gbif.common.shaded.com.fasterxml.jackson.dataformat.csv.CsvParser;
import org.gbif.common.shaded.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.gbif.utils.file.tabular.JacksonUtils;
import org.gbif.utils.file.tabular.TabularDataFileReader;

class JacksonCsvFileReader
implements TabularDataFileReader<List<String>> {
    private final MappingIterator<List<String>> it;
    private List<String> headerLine;
    private long lastLineNumber = 0L;
    private long recordNumber = 0L;

    JacksonCsvFileReader(Reader reader, char delimiterChar, String endOfLineSymbols, Character quoteChar, boolean headerLineIncluded) throws IOException {
        this(reader, delimiterChar, endOfLineSymbols, quoteChar, headerLineIncluded, null);
    }

    JacksonCsvFileReader(Reader reader, char delimiterChar, String endOfLineSymbols, Character quoteChar, boolean headerLineIncluded, Integer lineToSkipBeforeHeader) throws IOException {
        Objects.requireNonNull(reader, "reader shall be provided");
        Objects.requireNonNull(endOfLineSymbols, "endOfLineSymbols shall be provided");
        CsvMapper mapper = new CsvMapper();
        mapper.enable(CsvParser.Feature.WRAP_AS_ARRAY);
        CsvSchema schema = JacksonUtils.buildCsvSchema(delimiterChar, endOfLineSymbols, quoteChar);
        this.it = mapper.readerFor(List.class).with(schema).readValues(reader);
        for (int line = 0; line < Optional.ofNullable(lineToSkipBeforeHeader).orElse(0); ++line) {
            this.it.next();
        }
        if (headerLineIncluded && this.it.hasNext()) {
            this.headerLine = this.it.next();
        }
    }

    @Override
    public List<String> getHeaderLine() throws IOException {
        return this.headerLine;
    }

    @Override
    public long getLastRecordLineNumber() {
        return this.lastLineNumber;
    }

    @Override
    public long getLastRecordNumber() {
        return this.recordNumber;
    }

    @Override
    public List<String> read() throws IOException {
        while (this.it.hasNext()) {
            this.lastLineNumber = this.it.getCurrentLocation().getLineNr();
            List<String> row = this.it.next();
            if (row.size() == 1 && !StringUtils.isNotBlank(row.get(0))) continue;
            ++this.recordNumber;
            return row;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.it.close();
    }
}

