/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.shaded.com.fasterxml.jackson.dataformat.csv;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.gbif.common.shaded.com.fasterxml.jackson.core.Base64Variant;
import org.gbif.common.shaded.com.fasterxml.jackson.core.FormatFeature;
import org.gbif.common.shaded.com.fasterxml.jackson.core.FormatSchema;
import org.gbif.common.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import org.gbif.common.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.gbif.common.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.gbif.common.shaded.com.fasterxml.jackson.core.ObjectCodec;
import org.gbif.common.shaded.com.fasterxml.jackson.core.PrettyPrinter;
import org.gbif.common.shaded.com.fasterxml.jackson.core.SerializableString;
import org.gbif.common.shaded.com.fasterxml.jackson.core.Version;
import org.gbif.common.shaded.com.fasterxml.jackson.core.base.GeneratorBase;
import org.gbif.common.shaded.com.fasterxml.jackson.core.io.IOContext;
import org.gbif.common.shaded.com.fasterxml.jackson.core.json.JsonWriteContext;
import org.gbif.common.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.gbif.common.shaded.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.gbif.common.shaded.com.fasterxml.jackson.dataformat.csv.PackageVersion;
import org.gbif.common.shaded.com.fasterxml.jackson.dataformat.csv.impl.CsvEncoder;

public class CsvGenerator
extends GeneratorBase {
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    private static final CsvSchema EMPTY_SCHEMA = CsvSchema.emptySchema();
    protected final IOContext _ioContext;
    protected int _formatFeatures;
    protected CsvSchema _schema = EMPTY_SCHEMA;
    protected CsvEncoder _writer;
    protected boolean _handleFirstLine = true;
    protected int _nextColumnByName = -1;
    protected boolean _skipValue;
    protected String _arraySeparator = "";
    protected StringBuilder _arrayContents;
    protected int _arrayElements;
    protected JsonWriteContext _skipWithin;

    public CsvGenerator(IOContext ctxt, int jsonFeatures, int csvFeatures, ObjectCodec codec, Writer out, CsvSchema schema) {
        super(jsonFeatures, codec);
        this._ioContext = ctxt;
        this._formatFeatures = csvFeatures;
        this._schema = schema;
        this._writer = new CsvEncoder(ctxt, csvFeatures, out, schema);
    }

    public CsvGenerator(IOContext ctxt, int jsonFeatures, int csvFeatures, ObjectCodec codec, CsvEncoder csvWriter) {
        super(jsonFeatures, codec);
        this._ioContext = ctxt;
        this._formatFeatures = csvFeatures;
        this._writer = csvWriter;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public CsvGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public CsvGenerator setPrettyPrinter(PrettyPrinter pp) {
        return this;
    }

    @Override
    public Object getOutputTarget() {
        return this._writer.getOutputTarget();
    }

    @Override
    public int getOutputBuffered() {
        return this._writer.getOutputBuffered();
    }

    @Override
    public void setSchema(FormatSchema schema) {
        if (schema instanceof CsvSchema) {
            if (this._schema != schema) {
                this._schema = (CsvSchema)schema;
                this._writer = this._writer.withSchema(this._schema);
            }
        } else {
            super.setSchema(schema);
        }
    }

    @Override
    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    @Override
    public JsonGenerator overrideFormatFeatures(int values, int mask) {
        int oldF = this._formatFeatures;
        int newF = this._formatFeatures & ~mask | values & mask;
        if (oldF != newF) {
            this._formatFeatures = newF;
            this._writer.overrideFormatFeatures(newF);
        }
        return this;
    }

    @Override
    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof CsvSchema;
    }

    @Override
    public boolean canOmitFields() {
        return false;
    }

    @Override
    public boolean canWriteFormattedNumbers() {
        return true;
    }

    @Override
    public final void writeFieldName(String name) throws IOException {
        if (this._writeContext.writeFieldName(name) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name);
    }

    @Override
    public final void writeFieldName(SerializableString name) throws IOException {
        if (this._writeContext.writeFieldName(name.getValue()) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name.getValue());
    }

    @Override
    public final void writeStringField(String fieldName, String value) throws IOException {
        if (this._writeContext.writeFieldName(fieldName) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(fieldName);
        this.writeString(value);
    }

    private final void _writeFieldName(String name) throws IOException {
        if (this._schema == null) {
            this._reportMappingError("Unrecognized column '" + name + "', can not resolve without CsvSchema");
        }
        if (this._skipWithin != null) {
            this._skipValue = true;
            this._nextColumnByName = -1;
            return;
        }
        CsvSchema.Column col = this._schema.column(name, this._nextColumnByName + 1);
        if (col == null) {
            if (this.isEnabled(JsonGenerator.Feature.IGNORE_UNKNOWN)) {
                this._skipValue = true;
                this._nextColumnByName = -1;
                return;
            }
            this._reportMappingError("Unrecognized column '" + name + "': known columns: " + this._schema.getColumnDesc());
        }
        this._skipValue = false;
        this._nextColumnByName = col.getIndex();
    }

    public final boolean isEnabled(Feature f) {
        return (this._formatFeatures & f.getMask()) != 0;
    }

    public CsvGenerator configure(Feature f, boolean state) {
        if (state) {
            return this.enable(f);
        }
        return this.disable(f);
    }

    public CsvGenerator enable(Feature f) {
        this._formatFeatures |= f.getMask();
        this._writer.overrideFormatFeatures(this._formatFeatures);
        return this;
    }

    public CsvGenerator disable(Feature f) {
        this._formatFeatures &= ~f.getMask();
        this._writer.overrideFormatFeatures(this._formatFeatures);
        return this;
    }

    @Override
    public final void flush() throws IOException {
        this._writer.flush(this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM));
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.finishRow();
        if (this._handleFirstLine) {
            this._handleFirstLine();
        }
        this._writer.close(this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET));
    }

    @Override
    public final void writeStartArray() throws IOException {
        this._verifyValueWrite("start an array");
        if (this._writeContext.inObject()) {
            if (this._skipWithin == null && this._skipValue && this.isEnabled(JsonGenerator.Feature.IGNORE_UNKNOWN)) {
                this._skipWithin = this._writeContext;
            } else if (!this._skipValue) {
                CsvSchema.Column col;
                String sep = this._nextColumnByName >= 0 ? ((col = this._schema.column(this._nextColumnByName)).isArray() ? col.getArrayElementSeparator() : "") : "";
                if (sep.isEmpty()) {
                    if (!this._schema.hasArrayElementSeparator()) {
                        this._reportError("CSV generator does not support Array values for properties without setting 'arrayElementSeparator' in schema");
                    }
                    sep = this._schema.getArrayElementSeparator();
                }
                this._arraySeparator = sep;
                if (this._arrayContents == null) {
                    this._arrayContents = new StringBuilder();
                } else {
                    this._arrayContents.setLength(0);
                }
                this._arrayElements = 0;
            }
        } else if (!this._arraySeparator.isEmpty()) {
            this._reportError("CSV generator does not support nested Array values");
        }
        this._writeContext = this._writeContext.createChildArrayContext();
    }

    @Override
    public final void writeEndArray() throws IOException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not Array but " + this._writeContext.typeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        if (this._skipWithin != null) {
            if (this._writeContext == this._skipWithin) {
                this._skipWithin = null;
            }
            return;
        }
        if (!this._arraySeparator.isEmpty()) {
            this._arraySeparator = "";
            this._writer.write(this._columnIndex(), this._arrayContents.toString());
        }
        if (!this._writeContext.inObject()) {
            this.finishRow();
        }
    }

    @Override
    public final void writeStartObject() throws IOException {
        this._verifyValueWrite("start an object");
        if (this._writeContext.inObject() && this._skipWithin == null) {
            if (this._skipValue && this.isEnabled(JsonGenerator.Feature.IGNORE_UNKNOWN)) {
                this._skipWithin = this._writeContext;
            } else {
                this._reportMappingError("CSV generator does not support Object values for properties");
            }
        }
        this._writeContext = this._writeContext.createChildObjectContext();
    }

    @Override
    public final void writeEndObject() throws IOException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not Object but " + this._writeContext.typeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        if (this._skipWithin != null) {
            if (this._writeContext == this._skipWithin) {
                this._skipWithin = null;
            }
            return;
        }
        this.finishRow();
    }

    @Override
    public void writeString(String text) throws IOException {
        if (text == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(text);
            } else {
                this._writer.write(this._columnIndex(), text);
            }
        }
    }

    @Override
    public void writeString(char[] text, int offset, int len) throws IOException {
        this._verifyValueWrite("write String value");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(new String(text, offset, len));
            } else {
                this._writer.write(this._columnIndex(), text, offset, len);
            }
        }
    }

    @Override
    public final void writeString(SerializableString sstr) throws IOException {
        this._verifyValueWrite("write String value");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(sstr.getValue());
            } else {
                this._writer.write(this._columnIndex(), sstr.getValue());
            }
        }
    }

    @Override
    public void writeRawUTF8String(byte[] text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeUTF8String(byte[] text, int offset, int len) throws IOException {
        this.writeString(new String(text, offset, len, "UTF-8"));
    }

    @Override
    public void writeRaw(String text) throws IOException {
        this._writer.writeRaw(text);
    }

    @Override
    public void writeRaw(String text, int offset, int len) throws IOException {
        this._writer.writeRaw(text, offset, len);
    }

    @Override
    public void writeRaw(char[] text, int offset, int len) throws IOException {
        this._writer.writeRaw(text, offset, len);
    }

    @Override
    public void writeRaw(char c) throws IOException {
        this._writer.writeRaw(c);
    }

    @Override
    public void writeRawValue(String text) throws IOException {
        this._verifyValueWrite("write Raw value");
        if (!this._skipValue) {
            this._writer.writeNonEscaped(this._columnIndex(), text);
        }
    }

    @Override
    public void writeRawValue(String text, int offset, int len) throws IOException {
        this._verifyValueWrite("write Raw value");
        if (!this._skipValue) {
            this._writer.writeNonEscaped(this._columnIndex(), text.substring(offset, offset + len));
        }
    }

    @Override
    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        this._verifyValueWrite("write Raw value");
        if (!this._skipValue) {
            this._writer.writeNonEscaped(this._columnIndex(), new String(text, offset, len));
        }
    }

    @Override
    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException, JsonGenerationException {
        if (data == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (!this._skipValue) {
            if (offset > 0 || offset + len != data.length) {
                data = Arrays.copyOfRange(data, offset, offset + len);
            }
            String encoded = b64variant.encode(data);
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(encoded);
            } else {
                this._writer.write(this._columnIndex(), encoded);
            }
        }
    }

    @Override
    public void writeBoolean(boolean state) throws IOException {
        this._verifyValueWrite("write boolean value");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(state ? "true" : "false");
            } else {
                this._writer.write(this._columnIndex(), state);
            }
        }
    }

    @Override
    public void writeNull() throws IOException {
        this._verifyValueWrite("write null value");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(this._schema.getNullValueOrEmpty());
            } else if (this._writeContext.inObject()) {
                this._writer.writeNull(this._columnIndex());
            } else if (this._writeContext.inArray() && !this._writeContext.getParent().inRoot()) {
                this._writer.writeNull(this._columnIndex());
            }
        }
    }

    @Override
    public void writeNumber(int v) throws IOException {
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(String.valueOf(v));
            } else {
                this._writer.write(this._columnIndex(), v);
            }
        }
    }

    @Override
    public void writeNumber(long v) throws IOException {
        if (v <= Integer.MAX_VALUE && v >= Integer.MIN_VALUE) {
            this.writeNumber((int)v);
            return;
        }
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(String.valueOf(v));
            } else {
                this._writer.write(this._columnIndex(), v);
            }
        }
    }

    @Override
    public void writeNumber(BigInteger v) throws IOException {
        if (v == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(String.valueOf(v));
            } else {
                this._writer.write(this._columnIndex(), v.toString());
            }
        }
    }

    @Override
    public void writeNumber(double v) throws IOException {
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(String.valueOf(v));
            } else {
                this._writer.write(this._columnIndex(), v);
            }
        }
    }

    @Override
    public void writeNumber(float v) throws IOException {
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(String.valueOf(v));
            } else {
                this._writer.write(this._columnIndex(), v);
            }
        }
    }

    @Override
    public void writeNumber(BigDecimal v) throws IOException {
        if (v == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            String str;
            String string = str = this.isEnabled(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN) ? v.toPlainString() : v.toString();
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(String.valueOf(v));
            } else {
                this._writer.write(this._columnIndex(), str);
            }
        }
    }

    @Override
    public void writeNumber(String encodedValue) throws IOException {
        if (encodedValue == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(encodedValue);
            } else {
                this._writer.write(this._columnIndex(), encodedValue);
            }
        }
    }

    @Override
    public void writeOmittedField(String fieldName) throws IOException {
        CsvSchema.Column col = this._schema.column(fieldName);
        if (col != null) {
            if (this._writeContext.writeFieldName(fieldName) == 4) {
                this._reportError("Can not skip a field, expecting a value");
            }
            this._nextColumnByName = col.getIndex();
            this._verifyValueWrite("skip positional value due to filtering");
            this._writer.write(this._columnIndex(), "");
        }
    }

    @Override
    protected final void _verifyValueWrite(String typeMsg) throws IOException {
        int status = this._writeContext.writeValue();
        if (status == 5) {
            this._reportError("Can not " + typeMsg + ", expecting field name");
        }
        if (this._handleFirstLine) {
            this._handleFirstLine();
        }
    }

    @Override
    protected void _releaseBuffers() {
        this._writer._releaseBuffers();
    }

    protected void _reportMappingError(String msg) throws JsonProcessingException {
        throw JsonMappingException.from(this, msg);
    }

    protected final int _columnIndex() {
        int ix = this._nextColumnByName;
        if (ix < 0) {
            ix = this._writer.nextColumnIndex();
        }
        return ix;
    }

    protected void finishRow() throws IOException {
        this._writer.endRow();
        this._nextColumnByName = -1;
    }

    protected void _handleFirstLine() throws IOException {
        this._handleFirstLine = false;
        if (this._schema.usesHeader()) {
            int count = this._schema.size();
            if (count == 0) {
                this._reportMappingError("Schema specified that header line is to be written; but contains no column names");
            }
            for (CsvSchema.Column column : this._schema) {
                this._writer.writeColumnName(column.getName());
            }
            this._writer.endRow();
        }
    }

    protected void _addToArray(String value) {
        if (this._arrayElements > 0) {
            this._arrayContents.append(this._arraySeparator);
        }
        ++this._arrayElements;
        this._arrayContents.append(value);
    }

    protected void _addToArray(char[] value) {
        if (this._arrayElements > 0) {
            this._arrayContents.append(this._arraySeparator);
        }
        ++this._arrayElements;
        this._arrayContents.append(value);
    }

    public static enum Feature implements FormatFeature
    {
        STRICT_CHECK_FOR_QUOTING(false),
        OMIT_MISSING_TAIL_COLUMNS(false),
        ALWAYS_QUOTE_STRINGS(false),
        ALWAYS_QUOTE_EMPTY_STRINGS(false);

        protected final boolean _defaultState;
        protected final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        @Override
        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }

        @Override
        public boolean enabledByDefault() {
            return this._defaultState;
        }

        @Override
        public int getMask() {
            return this._mask;
        }
    }
}

