/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwca.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.gbif.dwca.io.Archive;
import org.gbif.dwca.io.ArchiveField;
import org.gbif.dwca.record.Record;
import org.gbif.dwca.record.RecordIterator;
import org.gbif.util.CSVReaderHelper;
import org.gbif.utils.file.csv.CSVReader;

public class ArchiveFile
implements Iterable<Record> {
    private static final TermFactory TERM_FACTORY = TermFactory.instance();
    public static final Term DEFAULT_ID_TERM = TermFactory.instance().findTerm("ARCHIVE_RECORD_ID");
    public static final Character DEFAULT_FIELDS_ENCLOSED_BY = Character.valueOf('\"');
    public static final String DEFAULT_FIELDS_TERMINATED_BY = ",";
    public static final String DEFAULT_LINES_TERMINATED_BY = "\n";
    private ArchiveField id;
    private Archive archive;
    private final LinkedList<String> locations = new LinkedList();
    private String title;
    private String fieldsTerminatedBy = ",";
    private Character fieldsEnclosedBy = DEFAULT_FIELDS_ENCLOSED_BY;
    private String linesTerminatedBy = "\n";
    private String encoding = "utf8";
    private Term rowType;
    private Integer ignoreHeaderLines = 0;
    private String dateFormat = "YYYY-MM-DD";
    private final Map<Term, ArchiveField> fields = new HashMap<Term, ArchiveField>();
    private final List<ArchiveField> rawArchiveFields = new ArrayList<ArchiveField>();

    public static ArchiveFile buildCsvFile() {
        ArchiveFile af = new ArchiveFile();
        af.setFieldsEnclosedBy(DEFAULT_FIELDS_ENCLOSED_BY);
        af.setFieldsTerminatedBy(DEFAULT_FIELDS_TERMINATED_BY);
        return af;
    }

    public static ArchiveFile buildTabFile() {
        ArchiveFile af = new ArchiveFile();
        af.setFieldsEnclosedBy(null);
        af.setFieldsTerminatedBy("\t");
        return af;
    }

    public static File getLocationFileSorted(File location) {
        return new File(location.getParentFile(), location.getName() + "-sorted");
    }

    public static String getLocationSorted(String location) {
        return location + "-sorted";
    }

    public void addField(ArchiveField field) {
        this.fields.put(field.getTerm(), field);
        this.rawArchiveFields.add(field);
    }

    public void addLocation(String location) {
        if (this.title == null) {
            this.title = location != null && location.lastIndexOf(47) > 1 ? location.substring(location.lastIndexOf(47) + 1, location.length()) : location;
        }
        this.locations.add(location);
    }

    public Archive getArchive() {
        return this.archive;
    }

    public CSVReader getCSVReader() throws IOException {
        return CSVReaderHelper.build(this);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public ArchiveField getField(Term term) {
        if (term == null) {
            return null;
        }
        return this.fields.get(term);
    }

    public ArchiveField getField(String term) {
        return this.getField(TERM_FACTORY.findTerm(term));
    }

    public Map<Term, ArchiveField> getFields() {
        return this.fields;
    }

    public Character getFieldsEnclosedBy() {
        return this.fieldsEnclosedBy;
    }

    public List<ArchiveField> getFieldsSorted() {
        ArrayList<ArchiveField> list = new ArrayList<ArchiveField>(this.fields.values());
        Collections.sort(list, new ArchiveFieldIndexComparator());
        return list;
    }

    public List<ArchiveField> getRawArchiveFields() {
        return new ArrayList<ArchiveField>(this.rawArchiveFields);
    }

    public Term[] getHeader() {
        Optional<Integer> idIndex;
        List archiveFieldsWithIndex = this.getFieldsSorted().stream().filter(af -> af.getIndex() != null).collect(Collectors.toList());
        Optional<Integer> optional = idIndex = this.id != null ? Optional.of(this.id.getIndex()) : Optional.empty();
        if (archiveFieldsWithIndex.isEmpty() && !idIndex.isPresent()) {
            return new Term[0];
        }
        int maxIndex = archiveFieldsWithIndex.stream().mapToInt(ArchiveField::getIndex).max().getAsInt();
        maxIndex = Math.max(maxIndex, idIndex.orElse(-1));
        Term[] terms = new Term[maxIndex + 1];
        idIndex.ifPresent(idx -> {
            terms[idx.intValue()] = DEFAULT_ID_TERM;
        });
        archiveFieldsWithIndex.stream().forEach(af -> {
            terms[af.getIndex().intValue()] = af.getTerm();
        });
        return terms;
    }

    public Optional<Map<Term, String>> getDefaultValues() {
        Map<Term, String> defaultValues = this.fields.values().stream().filter(af -> StringUtils.isNotBlank((CharSequence)af.getDefaultValue())).collect(Collectors.toMap(ArchiveField::getTerm, ArchiveField::getDefaultValue));
        return defaultValues.isEmpty() ? Optional.empty() : Optional.of(defaultValues);
    }

    public String getFieldsTerminatedBy() {
        return this.fieldsTerminatedBy;
    }

    public ArchiveField getId() {
        return this.id;
    }

    public Integer getIgnoreHeaderLines() {
        return this.ignoreHeaderLines;
    }

    public String getLinesTerminatedBy() {
        return this.linesTerminatedBy;
    }

    public String getLocation() {
        if (this.locations.isEmpty()) {
            return null;
        }
        return this.locations.getFirst();
    }

    public File getLocationFile() {
        File dataFile;
        if (this.archive != null) {
            if (this.getLocation() == null) {
                dataFile = this.archive.getLocation();
            } else if (this.getLocation().startsWith("/")) {
                dataFile = new File(this.getLocation());
            } else {
                Path archiveLocation = this.archive.getLocation().toPath();
                File directory = Files.isDirectory(archiveLocation, new LinkOption[0]) ? archiveLocation.toFile() : archiveLocation.getParent().toFile();
                dataFile = new File(directory, this.getLocation());
            }
        } else {
            dataFile = new File(this.getLocation());
        }
        return dataFile;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public Term getRowType() {
        return this.rowType;
    }

    public Set<Term> getTerms() {
        return this.fields.keySet();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasTerm(Term term) {
        return this.getField(term) != null;
    }

    public boolean hasTerm(String term) {
        return this.getField(term) != null;
    }

    @Override
    public Iterator<Record> iterator() {
        return RecordIterator.build(this, true, true);
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setEncoding(String encoding) {
        this.encoding = StringUtils.trimToNull((String)encoding);
    }

    public void setFieldsEnclosedBy(Character fieldsEnclosedBy) {
        this.fieldsEnclosedBy = fieldsEnclosedBy;
    }

    public void setFieldsTerminatedBy(String fieldsTerminatedBy) {
        this.fieldsTerminatedBy = (String)StringUtils.defaultIfEmpty((CharSequence)fieldsTerminatedBy, null);
    }

    public void setId(ArchiveField id) {
        this.id = id;
    }

    public void setIgnoreHeaderLines(Integer ignoreHeaderLines) {
        if (ignoreHeaderLines == null || ignoreHeaderLines < 0) {
            ignoreHeaderLines = 0;
        }
        this.ignoreHeaderLines = ignoreHeaderLines;
    }

    public void setLinesTerminatedBy(String linesTerminatedBy) {
        this.linesTerminatedBy = (String)StringUtils.defaultIfEmpty((CharSequence)linesTerminatedBy, null);
    }

    public void setRowType(Term rowType) {
        this.rowType = rowType;
    }

    public class ArchiveFieldIndexComparator
    implements Comparator<ArchiveField> {
        @Override
        public int compare(ArchiveField o1, ArchiveField o2) {
            if (o1.getIndex() == null && o2.getIndex() == null) {
                return 0;
            }
            if (o1.getIndex() == null) {
                return -1;
            }
            if (o2.getIndex() == null) {
                return 1;
            }
            if (o1.getIndex().equals(o2.getIndex())) {
                return o1.getTerm().qualifiedName().compareToIgnoreCase(o2.getTerm().qualifiedName());
            }
            return o1.getIndex().compareTo(o2.getIndex());
        }
    }
}

