/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwca.io;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.gbif.dwc.DwcFiles;
import org.gbif.dwc.meta.DwcMetaFiles;
import org.gbif.dwca.io.Archive;
import org.gbif.dwca.io.ArchiveFile;
import org.gbif.dwca.io.UnsupportedArchiveException;
import org.gbif.util.DownloadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveFactory.class);

    public static Archive openArchive(URL archiveUrl, File workingDir) throws IOException, UnsupportedArchiveException {
        File downloadTo = new File(workingDir, "dwca-download");
        File dwca = new File(workingDir, "dwca");
        DownloadUtil.download(archiveUrl, downloadTo);
        return ArchiveFactory.openArchive(downloadTo, dwca);
    }

    public static Archive openArchive(File archiveFile, File archiveDir) throws IOException, UnsupportedArchiveException {
        try {
            Archive archive = DwcFiles.fromCompressed(archiveFile.toPath(), archiveDir.toPath());
            return ArchiveFactory.validateArchive(archive);
        }
        catch (UnsupportedArchiveException uaEx) {
            LOG.debug("Could not uncompress archive [{}], try to read as single text file", (Object)archiveFile, (Object)uaEx);
            Archive arch = ArchiveFactory.openArchiveDataFile(archiveFile);
            Files.copy((File)archiveFile, (File)new File(archiveDir, archiveFile.getName()));
            return arch;
        }
    }

    public static Archive openArchiveDataFile(File dataFile) throws IOException, UnsupportedArchiveException {
        Archive archive = DwcFiles.fromLocation(dataFile.toPath());
        if (StringUtils.isBlank((CharSequence)archive.getMetadataLocation())) {
            DwcMetaFiles.discoverMetadataFile(dataFile.getParentFile().toPath()).ifPresent(archive::setMetadataLocation);
        }
        return ArchiveFactory.validateArchive(archive);
    }

    public static Archive openArchive(File dwcaFolder) throws IOException, UnsupportedArchiveException {
        Archive archive = DwcFiles.fromLocation(dwcaFolder.toPath());
        return ArchiveFactory.validateArchive(archive);
    }

    private static Archive validateArchive(Archive archive) throws UnsupportedArchiveException {
        ArchiveFactory.validateCoreFile(archive.getCore(), !archive.getExtensions().isEmpty());
        for (ArchiveFile af : archive.getExtensions()) {
            ArchiveFactory.validateExtensionFile(af);
        }
        LOG.debug("Archive contains " + archive.getExtensions().size() + " described extension files");
        LOG.debug("Archive contains " + archive.getCore().getFields().size() + " core properties");
        return archive;
    }

    private static void validateCoreFile(ArchiveFile f, boolean hasExtensions) throws UnsupportedArchiveException {
        if (hasExtensions && f.getId() == null) {
            LOG.warn("DwC-A core data file " + f.getTitle() + " is lacking an id column. No extensions allowed in this case");
        }
        ArchiveFactory.validateFile(f);
    }

    private static void validateExtensionFile(ArchiveFile f) throws UnsupportedArchiveException {
        if (f.getId() == null) {
            throw new UnsupportedArchiveException("DwC-A data file " + f.getTitle() + " requires an id or foreign key to the core id");
        }
        ArchiveFactory.validateFile(f);
    }

    private static void validateFile(ArchiveFile f) throws UnsupportedArchiveException {
        if (f == null) {
            throw new UnsupportedArchiveException("DwC-A data file is NULL");
        }
        if (f.getLocationFile() == null) {
            throw new UnsupportedArchiveException("DwC-A data file " + f.getTitle() + " requires a location");
        }
        if (f.getEncoding() == null) {
            throw new UnsupportedArchiveException("DwC-A data file " + f.getTitle() + " requires a character encoding");
        }
    }
}

