/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class LimitTokenCountFilterFactory
extends TokenFilterFactory {
    public static final String MAX_TOKEN_COUNT_KEY = "maxTokenCount";
    public static final String CONSUME_ALL_TOKENS_KEY = "consumeAllTokens";
    int maxTokenCount;
    boolean consumeAllTokens;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        this.maxTokenCount = this.getInt(MAX_TOKEN_COUNT_KEY);
        this.consumeAllTokens = this.getBoolean(CONSUME_ALL_TOKENS_KEY, false);
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new LimitTokenCountFilter(input, this.maxTokenCount, this.consumeAllTokens);
    }
}

