/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.terms;

import java.util.ArrayList;
import java.util.List;
import org.gbif.dwc.terms.AlternativeNames;
import org.gbif.dwc.terms.Term;

public enum GbifTerm implements Term,
AlternativeNames
{
    Description("RowType", new String[0]),
    Distribution("RowType", new String[0]),
    Identifier("RowType", new String[0]),
    Image("RowType", "Images"),
    Reference("RowType", "References"),
    SpeciesProfile("RowType", "SpeciesMiniProfile", "SpeciesInfo", "SpeciesData", "SpeciesFactsheet"),
    TypesAndSpecimen("RowType", "Specimen", "Types", "TypeDesignation"),
    VernacularName("RowType", "VernacularNames", "Vernacular", "Vernaculars"),
    Multimedia("RowType", new String[0]),
    datasetKey("Dataset", new String[0]),
    publishingCountry("Dataset", new String[0]),
    gbifID("Occurrence", new String[0]),
    lastInterpreted("Occurrence", new String[0]),
    coordinateAccuracy("Occurrence", new String[0]),
    elevation("Occurrence", new String[0]),
    elevationAccuracy("Occurrence", new String[0]),
    depth("Occurrence", new String[0]),
    depthAccuracy("Occurrence", new String[0]),
    distanceAboveSurface("Occurrence", new String[0]),
    distanceAboveSurfaceAccuracy("Occurrence", new String[0]),
    issue("Occurrence", new String[0]),
    mediaType("Occurrence", new String[0]),
    verbatimLabel("Occurrence", new String[0]),
    infraspecificMarker("Occurrence", new String[0]),
    typeDesignatedBy("Occurrence", new String[0]),
    typeDesignationType("Occurrence", new String[0]),
    hasCoordinate("Occurrence", new String[0]),
    hasGeospatialIssues("Occurrence", new String[0]),
    taxonKey("Taxon", new String[0]),
    kingdomKey("Taxon", new String[0]),
    phylumKey("Taxon", new String[0]),
    classKey("Taxon", new String[0]),
    orderKey("Taxon", new String[0]),
    familyKey("Taxon", new String[0]),
    genusKey("Taxon", new String[0]),
    subgenusKey("Taxon", new String[0]),
    speciesKey("Taxon", new String[0]),
    species("Taxon", new String[0]),
    canonicalName("Taxon", new String[0]),
    nameType("Taxon", new String[0]),
    genericName("Taxon", new String[0]),
    typifiedName("Identification", new String[0]),
    protocol("Crawling", new String[0]),
    lastParsed("Crawling", new String[0]),
    lastCrawled("Crawling", new String[0]),
    isMarine("SpeciesProfile", new String[0]),
    isTerrestrial("SpeciesProfile", new String[0]),
    isFreshwater("SpeciesProfile", new String[0]),
    isHybrid("SpeciesProfile", new String[0]),
    isExtinct("SpeciesProfile", new String[0]),
    livingPeriod("SpeciesProfile", "timePeriod"),
    lifeForm("SpeciesProfile", new String[0]),
    ageInDays("SpeciesProfile", new String[0]),
    sizeInMillimeter("SpeciesProfile", new String[0]),
    massInGram("SpeciesProfile", "weightInGram"),
    organismPart("VernacularName", new String[0]),
    isPlural("VernacularName", new String[0]),
    isPreferredName("VernacularName", new String[0]),
    appendixCITES("SpeciesDistribution", new String[0]);

    public static final String NS = "http://rs.gbif.org/terms/1.0/";
    public static final String PREFIX = "gbif";
    static final String[] PREFIXES;
    public static final String GROUP_CRAWLING = "Crawling";
    public static final String GROUP_DATASET = "Dataset";
    public static final String GROUP_ROW_TYPE = "RowType";
    public static final String GROUP_SPECIES_DISTRIBUTION_EXTENSION = "SpeciesDistribution";
    public static final String GROUP_SPECIES_PROFILE_EXTENSION = "SpeciesProfile";
    public static final String GROUP_VERNACULAR_NAME_EXTENSION = "VernacularName";
    public static final String[] GROUPS;
    public static final GbifTerm[] TAXONOMIC_TERMS;
    private final String groupName;
    public final String[] normAlts;

    private GbifTerm(String groupName, String ... alternatives) {
        this.groupName = groupName;
        this.normAlts = alternatives;
    }

    @Override
    public String qualifiedName() {
        return NS + this.simpleName();
    }

    @Override
    public String simpleName() {
        return this.name();
    }

    @Override
    public String[] alternativeNames() {
        return this.normAlts;
    }

    public String getGroup() {
        return this.groupName;
    }

    public static List<GbifTerm> listByGroup(String group) {
        ArrayList<GbifTerm> terms = new ArrayList<GbifTerm>();
        for (GbifTerm t : GbifTerm.values()) {
            if (!t.getGroup().equalsIgnoreCase(group)) continue;
            terms.add(t);
        }
        return terms;
    }

    public String toString() {
        return "gbif:" + this.name();
    }

    public boolean isClass() {
        return Character.isUpperCase(this.simpleName().charAt(0));
    }

    static {
        PREFIXES = new String[]{NS, "gbif:"};
        GROUPS = new String[]{GROUP_CRAWLING, GROUP_DATASET, "Occurrence", GROUP_ROW_TYPE, GROUP_SPECIES_DISTRIBUTION_EXTENSION, GROUP_SPECIES_PROFILE_EXTENSION, "Taxon", GROUP_VERNACULAR_NAME_EXTENSION};
        TAXONOMIC_TERMS = new GbifTerm[]{taxonKey, kingdomKey, phylumKey, classKey, orderKey, familyKey, genusKey, subgenusKey, speciesKey, species, canonicalName, nameType, genericName};
    }
}

