/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.file;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.text.StrTokenizer;
import org.gbif.dwc.text.ArchiveFile;
import org.gbif.file.CSVReaderFactory;
import org.gbif.utils.file.ClosableReportingIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVReader
implements ClosableReportingIterator<String[]>,
Iterable<String[]> {
    private static final Logger LOG = LoggerFactory.getLogger(CSVReader.class);
    public final int headerRows;
    public final String encoding;
    public final String delimiter;
    public final Character quoteChar;
    public final String[] header;
    private final StrTokenizer tokenizer;
    private String row;
    private int rows;
    private int readRows;
    private final Map<Integer, String> emptyLines;
    private final BufferedReader br;
    private boolean rowError;
    private String errorMessage;
    private Exception exception;

    public CSVReader(File source, String encoding, String delimiter, Character quotes, Integer headerRows) throws IOException {
        this(new FileInputStream(source), encoding, delimiter, quotes, headerRows);
    }

    public CSVReader(InputStream stream, String encoding, String delimiter, Character quotes, Integer headerRows) throws IOException {
        Cache cache = CacheBuilder.newBuilder().maximumSize(1000L).build();
        this.emptyLines = cache.asMap();
        this.rows = 0;
        this.readRows = 0;
        this.delimiter = delimiter;
        this.encoding = encoding;
        this.quoteChar = quotes;
        this.headerRows = headerRows == null || headerRows < 0 ? 0 : headerRows;
        this.tokenizer = new StrTokenizer();
        this.tokenizer.setDelimiterString(delimiter);
        if (quotes != null) {
            this.tokenizer.setQuoteChar(quotes.charValue());
        }
        this.tokenizer.setIgnoreEmptyTokens(false);
        this.tokenizer.reset();
        InputStreamReader reader = new InputStreamReader(stream, encoding);
        this.br = new BufferedReader(reader);
        this.row = this.br.readLine();
        if (this.row == null) {
            this.header = null;
        } else {
            this.tokenizer.reset(this.row);
            this.header = this.tokenizer.getTokenArray();
        }
        while (headerRows > 0) {
            Integer n = headerRows;
            Integer n2 = headerRows = Integer.valueOf(headerRows - 1);
            this.row = this.br.readLine();
        }
    }

    public static CSVReader build(ArchiveFile source) throws IOException {
        return CSVReaderFactory.build(source);
    }

    public static CSVReader build(File source) throws IOException {
        return CSVReaderFactory.build(source);
    }

    public static CSVReader build(File source, String delimiter, boolean header) throws IOException {
        return CSVReaderFactory.build(source, delimiter, header);
    }

    public static CSVReader build(File source, String encoding, String delimiter, Character quotes, int headerRows) throws IOException {
        return CSVReaderFactory.build(source, encoding, delimiter, quotes, (Integer)headerRows);
    }

    public static CSVReader build(File source, String encoding, String delimiter, int headerRows) throws IOException {
        return CSVReaderFactory.build(source, encoding, delimiter, headerRows);
    }

    public void close() {
        try {
            this.br.close();
        }
        catch (IOException e) {
            LOG.debug("Exception caught", (Throwable)e);
        }
    }

    public int currLineNumber() {
        return this.rows;
    }

    public Set<Integer> getEmptyLines() {
        return this.emptyLines.keySet();
    }

    public int getReadRows() {
        return this.readRows;
    }

    public boolean hasNext() {
        return this.row != null;
    }

    @Override
    public ClosableReportingIterator<String[]> iterator() {
        return this;
    }

    public String[] next() {
        if (this.row == null) {
            return null;
        }
        this.tokenizer.reset(this.row);
        this.resetReportingIterator();
        try {
            this.row = this.br.readLine();
            ++this.rows;
            while (this.row != null && this.row.length() == 0) {
                this.emptyLines.put(this.rows + this.headerRows + 1, "");
                this.row = this.br.readLine();
                ++this.rows;
            }
            ++this.readRows;
        }
        catch (IOException e) {
            LOG.debug("Exception caught", (Throwable)e);
            this.rowError = true;
            this.exception = e;
            StringBuilder msg = new StringBuilder();
            msg.append("Exception caught: ");
            msg.append(e.getMessage());
            if (!Strings.isNullOrEmpty((String)this.row)) {
                msg.append("\n");
                msg.append("Row: ");
                msg.append(this.row);
            }
            this.errorMessage = msg.toString();
            this.row = null;
        }
        return this.tokenizer.getTokenArray();
    }

    private void resetReportingIterator() {
        this.rowError = false;
        this.exception = null;
        this.errorMessage = null;
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }

    public boolean hasRowError() {
        return this.rowError;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Exception getException() {
        return this.exception;
    }
}

