/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gbif.dwc.record.DarwinCoreRecord;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.gbif.dwc.text.Archive;
import org.gbif.dwc.text.ArchiveFactory;
import org.gbif.dwc.text.ArchiveField;
import org.gbif.dwc.text.ArchiveFile;
import org.gbif.dwc.tools.IdGenerator;
import org.gbif.dwc.tools.IntSequenceGenerator;
import org.gbif.file.CSVReader;
import org.gbif.utils.file.ClosableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreIdRenamer {
    private final IdGenerator idGen;

    public CoreIdRenamer() {
        this.idGen = new IntSequenceGenerator(1);
    }

    public CoreIdRenamer(IdGenerator idGen) {
        this.idGen = idGen;
    }

    public CoreIdRenamer(int firstId) {
        this.idGen = new IntSequenceGenerator(firstId);
    }

    public void rename(File dwca) throws IOException {
        this.rename(ArchiveFactory.openArchive(dwca));
    }

    public void rename(Archive arch) throws IOException {
        ArchiveField id = arch.getCore().getId();
        TermFactory fact = TermFactory.instance();
        Term rowType = fact.findTerm(arch.getCore().getRowType());
        ArrayList<Term> relatedTerms = new ArrayList<Term>();
        if (DwcTerm.Taxon == rowType) {
            if (arch.getCore().hasTerm(DwcTerm.parentNameUsageID)) {
                relatedTerms.add(DwcTerm.parentNameUsageID);
            }
            if (arch.getCore().hasTerm(DwcTerm.acceptedNameUsageID)) {
                relatedTerms.add(DwcTerm.acceptedNameUsageID);
            }
            if (arch.getCore().hasTerm(DwcTerm.originalNameUsageID)) {
                relatedTerms.add(DwcTerm.originalNameUsageID);
            }
        } else if (DwcTerm.Occurrence != rowType) {
            throw new IllegalStateException("Unknown core rowtype - cannot rename the archive ids");
        }
        HashMap<String, String> old2new = new HashMap<String, String>();
        ClosableIterator<DarwinCoreRecord> iter = arch.iteratorDwc();
        System.out.println("Mapping record ids ...");
        while (iter.hasNext()) {
            DarwinCoreRecord rec = (DarwinCoreRecord)iter.next();
            old2new.put(rec.id(), this.idGen.nextId());
        }
        System.out.println("Mapped " + old2new.size() + " record ids. Rewrite files ...");
        this.rewriteFile(arch.getCore(), old2new, relatedTerms);
        for (ArchiveFile af : arch.getExtensions()) {
            this.rewriteFile(arch.getCore(), old2new, relatedTerms);
        }
    }

    private void rewriteFile(ArchiveFile original, Map<String, String> old2new, List<Term> relatedTerms) throws IOException {
        File newFile = new File(original.getLocationFile().getParent(), original.getLocationFile().getName() + "-NEW");
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFile, false), original.getEncoding()));
        ArrayList<Integer> renameCols = new ArrayList<Integer>();
        renameCols.add(original.getId().getIndex());
        for (Term t : relatedTerms) {
            if (!original.hasTerm(t)) continue;
            renameCols.add(original.getField(t).getIndex());
        }
        CSVReader reader = original.getCSVReader();
        String quote = original.getFieldsEnclosedBy() == null ? "" : original.getFieldsEnclosedBy().toString();
        String quoteDelimQuote = quote + original.getFieldsTerminatedBy() + quote;
        for (int hr = reader.headerRows; hr > 0; --hr) {
            String rowAsString = quote + StringUtils.join((Object[])reader.header, (String)quoteDelimQuote) + quote;
            writer.write(rowAsString);
            ((Writer)writer).write(10);
        }
        for (Object[] row : reader) {
            for (Integer col : renameCols) {
                row[col.intValue()] = old2new.get(row[col]);
            }
            String rowAsString = quote + StringUtils.join((Object[])row, (String)quoteDelimQuote) + quote;
            writer.write(rowAsString);
            ((Writer)writer).write(10);
        }
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public static void main(String[] args) throws IOException {
        CoreIdRenamer renamer = new CoreIdRenamer();
        Archive arch = ArchiveFactory.openArchive(new File("/Users/markus/Desktop/ecat_checklist"));
        arch.getCore().setRowType(DwcTerm.Taxon.qualifiedName());
        renamer.rename(arch);
    }
}

