/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.record;

import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DarwinCoreTaxon {
    private static final Logger LOG = LoggerFactory.getLogger(DarwinCoreTaxon.class);
    private static final String CLASSIFICATION_DELIMITER = ";";
    private static final Pattern NORM_AUTHORS = Pattern.compile("[^a-z0-9]+");
    private String basisOfRecord;
    private String taxonID;
    private String taxonConceptID;
    private String datasetID;
    private String datasetName;
    private String source;
    private String modified;
    private String accessrights;
    private String rights;
    private String rightsholder;
    private String language;
    private String higherClassification;
    private String kingdom;
    private String phylum;
    private String classs;
    private String order;
    private String family;
    private String genus;
    private String subgenus;
    private String genericName;
    private String specificEpithet;
    private String infraspecificEpithet;
    private String scientificName;
    private String scientificNameID;
    private String vernacularName;
    private String taxonRank;
    private String verbatimTaxonRank;
    private String infraspecificMarker;
    private String scientificNameAuthorship;
    private String nomenclaturalCode;
    private String namePublishedIn;
    private String namePublishedInID;
    private String taxonomicStatus;
    private String nomenclaturalStatus;
    private String nameAccordingTo;
    private String nameAccordingToID;
    private String parentNameUsageID;
    private String parentNameUsage;
    private String originalNameUsageID;
    private String originalNameUsage;
    private String acceptedNameUsageID;
    private String acceptedNameUsage;
    private String taxonRemarks;
    private String dynamicProperties;
    private String namePublishedInYear;
    private String collectionCode;
    private String collectionID;
    private String dataGeneralizations;
    private String informationWithheld;
    private String institutionCode;
    private String institutionID;
    private String ownerInstitutionCode;

    public DarwinCoreTaxon() {
    }

    public DarwinCoreTaxon(String scientificName) {
        this.scientificName = this.norm(scientificName);
    }

    public String buildHigherClassification(Character lowestRank) {
        StringBuilder buf = new StringBuilder();
        if (this.kingdom != null) {
            buf.append(StringUtils.capitalize((String)this.kingdom.toLowerCase()));
            buf.append(CLASSIFICATION_DELIMITER);
        }
        if (lowestRank == null || lowestRank.charValue() != 'k') {
            if (this.phylum != null) {
                buf.append(StringUtils.capitalize((String)this.phylum.toLowerCase()));
                buf.append(CLASSIFICATION_DELIMITER);
            }
            if (lowestRank == null || lowestRank.charValue() != 'p') {
                if (this.classs != null) {
                    buf.append(StringUtils.capitalize((String)this.classs.toLowerCase()));
                    buf.append(CLASSIFICATION_DELIMITER);
                }
                if (lowestRank == null || lowestRank.charValue() != 'c') {
                    if (this.order != null) {
                        buf.append(StringUtils.capitalize((String)this.order.toLowerCase()));
                        buf.append(CLASSIFICATION_DELIMITER);
                    }
                    if (lowestRank == null || lowestRank.charValue() != 'o') {
                        if (this.family != null) {
                            buf.append(StringUtils.capitalize((String)this.family.toLowerCase()));
                            buf.append(CLASSIFICATION_DELIMITER);
                        }
                        if (lowestRank == null || lowestRank.charValue() != 'f') {
                            if (this.genus != null) {
                                buf.append(StringUtils.capitalize((String)this.genus.toLowerCase()));
                                buf.append(CLASSIFICATION_DELIMITER);
                            }
                            if ((lowestRank == null || lowestRank.charValue() != 'g') && this.subgenus != null) {
                                buf.append(StringUtils.capitalize((String)this.subgenus.toLowerCase()));
                                buf.append(CLASSIFICATION_DELIMITER);
                            }
                        }
                    }
                }
            }
        }
        if (buf.length() > 1) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public void setInstitutionID(String institutionID) {
        this.institutionID = institutionID;
    }

    public String getOwnerInstitutionCode() {
        return this.ownerInstitutionCode;
    }

    public void setOwnerInstitutionCode(String ownerInstitutionCode) {
        this.ownerInstitutionCode = ownerInstitutionCode;
    }

    public void clear() {
        this.source = null;
        this.modified = null;
        this.accessrights = null;
        this.rights = null;
        this.rightsholder = null;
        this.language = null;
        this.datasetID = null;
        this.datasetName = null;
        for (DwcTerm t : DwcTerm.TAXONOMIC_TERMS) {
            this.setProperty(t, null);
        }
    }

    public String getAcceptedNameUsage() {
        return this.acceptedNameUsage;
    }

    public String getAcceptedNameUsageID() {
        return this.acceptedNameUsageID;
    }

    public String getAccessrights() {
        return this.accessrights;
    }

    public String getClasss() {
        return this.classs;
    }

    public String getDatasetID() {
        return this.datasetID;
    }

    public String getFamily() {
        return this.family;
    }

    public String getFullScientificName() {
        String normedAuthors;
        String normedSciName;
        if (this.scientificNameAuthorship != null && this.scientificName != null && !(normedSciName = NORM_AUTHORS.matcher(this.scientificName.toLowerCase()).replaceAll(" ")).contains(normedAuthors = NORM_AUTHORS.matcher(this.scientificNameAuthorship.toLowerCase()).replaceAll(" "))) {
            return this.scientificName + " " + this.scientificNameAuthorship;
        }
        if (this.scientificName == null) {
            String sciname = null;
            if (this.genericName != null || this.genus != null) {
                String genus;
                String string = genus = this.genericName != null ? this.genericName : this.genus;
                if (this.specificEpithet != null) {
                    sciname = genus + " " + this.specificEpithet;
                    if (this.infraspecificEpithet != null) {
                        if (this.infraspecificMarker != null) {
                            sciname = sciname + " " + this.infraspecificMarker;
                        }
                        sciname = sciname + " " + this.infraspecificEpithet;
                    }
                    if (sciname != null && this.scientificNameAuthorship != null) {
                        sciname = sciname + " " + this.scientificNameAuthorship;
                    }
                } else {
                    sciname = this.subgenus != null ? this.subgenus : genus;
                }
            }
            return sciname;
        }
        return this.scientificName;
    }

    public String getGenus() {
        return this.genus;
    }

    public String getGenericName() {
        return this.genericName;
    }

    public String getHigherClassification() {
        return this.higherClassification;
    }

    public String getInfraspecificEpithet() {
        return this.infraspecificEpithet;
    }

    public String getInfraspecificMarker() {
        return this.infraspecificMarker;
    }

    public String getKingdom() {
        return this.kingdom;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLowestScientificName() {
        String sciname = this.getFullScientificName();
        if (sciname == null) {
            if (this.family != null) {
                sciname = this.family;
            } else if (this.order != null) {
                sciname = this.order;
            } else if (this.classs != null) {
                sciname = this.classs;
            } else if (this.phylum != null) {
                sciname = this.phylum;
            } else if (this.kingdom != null) {
                sciname = this.kingdom;
            }
        }
        return sciname;
    }

    public String getModified() {
        return this.modified;
    }

    public String getNameAccordingTo() {
        return this.nameAccordingTo;
    }

    public String getNameAccordingToID() {
        return this.nameAccordingToID;
    }

    public String getNamePublishedIn() {
        return this.namePublishedIn;
    }

    public String getNamePublishedInID() {
        return this.namePublishedInID;
    }

    public String getNomenclaturalCode() {
        return this.nomenclaturalCode;
    }

    public String getNomenclaturalStatus() {
        return this.nomenclaturalStatus;
    }

    public String getOrder() {
        return this.order;
    }

    public String getOriginalNameUsage() {
        return this.originalNameUsage;
    }

    public String getOriginalNameUsageID() {
        return this.originalNameUsageID;
    }

    public String getParentNameUsage() {
        return this.parentNameUsage;
    }

    public String getParentNameUsageID() {
        return this.parentNameUsageID;
    }

    public String getPhylum() {
        return this.phylum;
    }

    public String getProperty(Term prop) {
        String getter = String.format("get%s", this.getPropertyName(prop));
        try {
            Method m = this.getClass().getMethod(getter, new Class[0]);
            Object val = m.invoke((Object)this, new Object[0]);
            return val == null ? null : val.toString();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("non existing dwc property: " + prop);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getBasisOfRecord() {
        return this.basisOfRecord;
    }

    public void setBasisOfRecord(String basisOfRecord) {
        this.basisOfRecord = this.norm(basisOfRecord);
    }

    public String getCollectionCode() {
        return this.collectionCode;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public String getDataGeneralizations() {
        return this.dataGeneralizations;
    }

    public String getInformationWithheld() {
        return this.informationWithheld;
    }

    public String getInstitutionCode() {
        return this.institutionCode;
    }

    public void setCollectionCode(String collectionCode) {
        this.collectionCode = this.norm(collectionCode);
    }

    public void setCollectionID(String collectionID) {
        this.collectionID = this.norm(collectionID);
    }

    public void setDataGeneralizations(String dataGeneralizations) {
        this.dataGeneralizations = this.norm(dataGeneralizations);
    }

    public void setInformationWithheld(String informationWithheld) {
        this.informationWithheld = this.norm(informationWithheld);
    }

    public void setInstitutionCode(String institutionCode) {
        this.institutionCode = this.norm(institutionCode);
    }

    private String getPropertyName(Term prop) {
        String propName = StringUtils.capitalize((String)prop.simpleName());
        if (propName.equalsIgnoreCase("Class")) {
            propName = "Classs";
        }
        return propName;
    }

    public String getRights() {
        return this.rights;
    }

    public String getRightsholder() {
        return this.rightsholder;
    }

    public String getScientificName() {
        return this.scientificName;
    }

    public String getScientificNameAuthorship() {
        return this.scientificNameAuthorship;
    }

    public String getScientificNameID() {
        return this.scientificNameID;
    }

    public String getSource() {
        return this.source;
    }

    public String getSpecificEpithet() {
        return this.specificEpithet;
    }

    public String getSubgenus() {
        return this.subgenus;
    }

    public String getTaxonConceptID() {
        return this.taxonConceptID;
    }

    public String getTaxonID() {
        return this.taxonID;
    }

    public String getTaxonomicStatus() {
        return this.taxonomicStatus;
    }

    public String getTaxonRank() {
        return this.taxonRank;
    }

    public String getTaxonRankInterpreted() {
        if (this.scientificName != null || this.taxonRank != null) {
            return this.taxonRank;
        }
        if (this.genus != null && this.specificEpithet != null && this.infraspecificEpithet != null) {
            if (this.infraspecificMarker != null) {
                return this.infraspecificMarker;
            }
            return "infraspecies";
        }
        if (this.genus != null && this.specificEpithet != null) {
            return "species";
        }
        if (this.subgenus != null) {
            return "subgenus";
        }
        if (this.genus != null) {
            return "genus";
        }
        if (this.family != null) {
            return "family";
        }
        if (this.order != null) {
            return "order";
        }
        if (this.classs != null) {
            return "class";
        }
        if (this.phylum != null) {
            return "phylum";
        }
        if (this.kingdom != null) {
            return "kingdom";
        }
        return null;
    }

    public String getTaxonRemarks() {
        return this.taxonRemarks;
    }

    public String getVerbatimTaxonRank() {
        return this.verbatimTaxonRank;
    }

    public String getVernacularName() {
        return this.vernacularName;
    }

    protected String norm(String x) {
        if ((x = StringUtils.trimToNull((String)x)) != null && (x.equalsIgnoreCase("\\N") || x.equalsIgnoreCase("NULL"))) {
            x = null;
        }
        return x;
    }

    public void setAcceptedNameUsage(String acceptedNameUsage) {
        this.acceptedNameUsage = acceptedNameUsage;
    }

    public void setAcceptedNameUsageID(String acceptedNameUsageID) {
        this.acceptedNameUsageID = acceptedNameUsageID;
    }

    public void setAccessrights(String accessrights) {
        this.accessrights = this.norm(accessrights);
    }

    public void setClasss(String classs) {
        this.classs = this.norm(classs);
    }

    public void setDatasetID(String datasetID) {
        this.datasetID = this.norm(datasetID);
    }

    public void setFamily(String family) {
        this.family = this.norm(family);
    }

    public void setGenus(String genus) {
        this.genus = this.norm(genus);
    }

    public void setGenericName(String genericName) {
        this.genericName = genericName;
    }

    public void setHigherClassification(String higherClassification) {
        this.higherClassification = higherClassification;
    }

    public void setInfraspecificEpithet(String infraspecificEpithet) {
        this.infraspecificEpithet = this.norm(infraspecificEpithet);
    }

    public void setInfraspecificMarker(String infraspecificMarker) {
        this.infraspecificMarker = infraspecificMarker;
    }

    public void setKingdom(String kingdom) {
        this.kingdom = this.norm(kingdom);
    }

    public void setLanguage(String language) {
        this.language = this.norm(language);
    }

    public void setModified(String modified) {
        this.modified = this.norm(modified);
    }

    public void setNameAccordingTo(String nameAccordingTo) {
        this.nameAccordingTo = nameAccordingTo;
    }

    public void setNameAccordingToID(String nameAccordingToID) {
        this.nameAccordingToID = nameAccordingToID;
    }

    public void setNamePublishedIn(String namePublishedIn) {
        this.namePublishedIn = this.norm(namePublishedIn);
    }

    public void setNamePublishedInID(String namePublishedInID) {
        this.namePublishedInID = namePublishedInID;
    }

    public void setNomenclaturalCode(String nomenclaturalCode) {
        this.nomenclaturalCode = this.norm(nomenclaturalCode);
    }

    public void setNomenclaturalStatus(String nomenclaturalStatus) {
        this.nomenclaturalStatus = this.norm(nomenclaturalStatus);
    }

    public void setOrder(String order) {
        this.order = this.norm(order);
    }

    public void setOriginalNameUsage(String originalNameUsage) {
        this.originalNameUsage = originalNameUsage;
    }

    public void setOriginalNameUsageID(String originalNameUsageID) {
        this.originalNameUsageID = originalNameUsageID;
    }

    public void setParentNameUsage(String parentNameUsage) {
        this.parentNameUsage = parentNameUsage;
    }

    public void setParentNameUsageID(String parentNameUsageID) {
        this.parentNameUsageID = parentNameUsageID;
    }

    public void setPhylum(String phylum) {
        this.phylum = this.norm(phylum);
    }

    public boolean setProperty(Term prop, String value) {
        if (prop == null) {
            return false;
        }
        String setterName = null;
        try {
            setterName = String.format("set%s", this.getPropertyName(prop));
            Method m = this.getClass().getMethod(setterName, String.class);
            m.invoke((Object)this, value);
        }
        catch (Exception e) {
            LOG.warn("Trying to access bad dwc property setter: " + setterName + " for property " + prop);
            return false;
        }
        return true;
    }

    public void setRights(String rights) {
        this.rights = this.norm(rights);
    }

    public void setRightsholder(String rightsholder) {
        this.rightsholder = this.norm(rightsholder);
    }

    public void setScientificName(String scientificName) {
        this.scientificName = this.norm(scientificName);
    }

    public void setScientificNameAuthorship(String scientificNameAuthorship) {
        this.scientificNameAuthorship = this.norm(scientificNameAuthorship);
    }

    public void setScientificNameID(String scientificNameID) {
        this.scientificNameID = scientificNameID;
    }

    public void setSource(String source) {
        this.source = this.norm(source);
    }

    public void setSpecificEpithet(String specificEpithet) {
        this.specificEpithet = this.norm(specificEpithet);
    }

    public void setSubgenus(String subgenus) {
        this.subgenus = this.norm(subgenus);
    }

    public void setTaxonConceptID(String taxonConceptID) {
        this.taxonConceptID = taxonConceptID;
    }

    public void setTaxonID(String taxonID) {
        this.taxonID = this.norm(taxonID);
    }

    public void setTaxonomicStatus(String taxonomicStatus) {
        this.taxonomicStatus = this.norm(taxonomicStatus);
    }

    public void setTaxonRank(String taxonRank) {
        this.taxonRank = this.norm(taxonRank);
    }

    public void setTaxonRemarks(String taxonRemarks) {
        this.taxonRemarks = this.norm(taxonRemarks);
    }

    public void setVerbatimTaxonRank(String verbatimTaxonRank) {
        this.verbatimTaxonRank = verbatimTaxonRank;
    }

    public void setVernacularName(String vernacularName) {
        this.vernacularName = vernacularName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("taxonID", (Object)this.taxonID).append("scientificName", (Object)this.scientificName).toString();
    }

    public String getDynamicProperties() {
        return this.dynamicProperties;
    }

    public void setDynamicProperties(String dynamicProperties) {
        this.dynamicProperties = dynamicProperties;
    }

    public String getNamePublishedInYear() {
        return this.namePublishedInYear;
    }

    public void setNamePublishedInYear(String namePublishedInYear) {
        this.namePublishedInYear = namePublishedInYear;
    }
}

