/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.search;

import au.org.ala.names.lucene.analyzer.LowerCaseKeywordAnalyzer;
import au.org.ala.names.model.ALAParsedName;
import au.org.ala.names.model.ErrorType;
import au.org.ala.names.model.LinnaeanRankClassification;
import au.org.ala.names.model.MatchType;
import au.org.ala.names.model.MetricsResultDTO;
import au.org.ala.names.model.NameIndexField;
import au.org.ala.names.model.NameSearchResult;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.SynonymType;
import au.org.ala.names.parser.PhraseNameParser;
import au.org.ala.names.search.ALANameIndexer;
import au.org.ala.names.search.ExcludedNameException;
import au.org.ala.names.search.HomonymException;
import au.org.ala.names.search.MisappliedException;
import au.org.ala.names.search.ParentSynonymChildException;
import au.org.ala.names.search.SPPException;
import au.org.ala.names.search.SearchResultException;
import au.org.ala.names.util.TaxonNameSoundEx;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.gbif.ecat.model.ParsedName;
import org.gbif.ecat.parser.UnparsableException;
import org.gbif.ecat.voc.NameType;
import uk.ac.shef.wit.simmetrics.similaritymetrics.SmithWatermanGotoh;

public class ALANameSearcher {
    protected Log log = LogFactory.getLog(ALANameSearcher.class);
    private DirectoryReader cbReader;
    private DirectoryReader irmngReader;
    private DirectoryReader vernReader;
    private IndexSearcher cbSearcher;
    private IndexSearcher irmngSearcher;
    private IndexSearcher vernSearcher;
    private IndexSearcher idSearcher;
    private ThreadLocal<QueryParser> queryParser;
    private ThreadLocal<QueryParser> idParser;
    protected TaxonNameSoundEx tnse;
    private PhraseNameParser parser;
    public static final Pattern virusStopPattern = Pattern.compile(" virus| ictv| ICTV");
    public static final Pattern voucherRemovePattern = Pattern.compile(" |,|&|\\.");
    public static final Pattern affPattern = Pattern.compile("([\\x00-\\x7F\\s]*) aff[#!?\\\\. ]([\\x00-\\x7F\\s]*)");
    public static final Pattern cfPattern = Pattern.compile("([\\x00-\\x7F\\s]*) cf[#!?\\\\. ]([\\x00-\\x7F\\s]*)");
    private Set crossRankHomonyms;

    public ALANameSearcher() {
    }

    public ALANameSearcher(String indexDirectory) throws IOException {
        this.log.debug((Object)"Creating the search object for the name matching api...");
        this.queryParser = new ThreadLocal<QueryParser>(){

            @Override
            protected QueryParser initialValue() {
                QueryParser qp = new QueryParser(Version.LUCENE_34, "genus", (Analyzer)new LowerCaseKeywordAnalyzer());
                qp.setFuzzyMinSim(0.8f);
                return qp;
            }
        };
        this.idParser = new ThreadLocal<QueryParser>(){

            @Override
            protected QueryParser initialValue() {
                return new QueryParser(Version.LUCENE_34, "lsid", (Analyzer)new KeywordAnalyzer());
            }
        };
        this.cbReader = DirectoryReader.open((Directory)FSDirectory.open((File)this.createIfNotExist(indexDirectory + File.separator + "cb")));
        this.cbSearcher = new IndexSearcher((IndexReader)this.cbReader);
        this.irmngReader = DirectoryReader.open((Directory)FSDirectory.open((File)this.createIfNotExist(indexDirectory + File.separator + "irmng")));
        this.irmngSearcher = new IndexSearcher((IndexReader)this.irmngReader);
        this.vernReader = DirectoryReader.open((Directory)FSDirectory.open((File)this.createIfNotExist(indexDirectory + File.separator + "vernacular")));
        this.vernSearcher = new IndexSearcher((IndexReader)this.vernReader);
        this.idSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)FSDirectory.open((File)this.createIfNotExist(indexDirectory + File.separator + "id"))));
        this.tnse = new TaxonNameSoundEx();
        this.parser = new PhraseNameParser();
        this.crossRankHomonyms = au.org.ala.names.util.FileUtils.streamToSet(this.getClass().getClassLoader().getResourceAsStream("au/org/ala/homonyms/cross_rank_homonyms.txt"), new HashSet<String>(), true);
    }

    private File createIfNotExist(String indexDirectory) throws IOException {
        File idxFile = new File(indexDirectory);
        if (!idxFile.exists()) {
            FileUtils.forceMkdir((File)idxFile);
            StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_34);
            IndexWriterConfig conf = new IndexWriterConfig(Version.LUCENE_34, (Analyzer)analyzer);
            IndexWriter iw = new IndexWriter((Directory)FSDirectory.open((File)idxFile), conf);
            iw.commit();
            iw.close();
        }
        return idxFile;
    }

    public void dumpSpecies() {
        try {
            OutputStreamWriter fileOut = new OutputStreamWriter((OutputStream)new FileOutputStream("/data/species.txt"), "UTF-8");
            Term term = new Term("rank", "species");
            TopDocs hits = this.cbSearcher.search((Query)new TermQuery(term), 2000000);
            for (ScoreDoc sdoc : hits.scoreDocs) {
                Document doc = this.cbReader.document(sdoc.doc);
                if (doc.getField("synonym") != null) continue;
                String lsid = StringUtils.trimToNull((String)doc.getField("lsid").stringValue());
                if (lsid == null) {
                    lsid = doc.getField("id").stringValue();
                }
                fileOut.write(lsid + "\n");
            }
            fileOut.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String searchForLSID(String name, boolean fuzzy) throws SearchResultException {
        return this.searchForLSID(name, null, fuzzy);
    }

    public String searchForLSID(String name, boolean fuzzy, boolean ignoreHomonyms) throws SearchResultException {
        return this.searchForLSID(name, null, fuzzy, ignoreHomonyms);
    }

    public String searchForLSID(String name) throws SearchResultException {
        return this.searchForLSID(name, false);
    }

    public String searchForLSID(String name, RankType rank, boolean fuzzy) throws SearchResultException {
        return this.searchForLSID(name, null, rank, fuzzy, false);
    }

    public String searchForLSID(String name, RankType rank, boolean fuzzy, boolean ignoreHomonyms) throws SearchResultException {
        return this.searchForLSID(name, null, rank, fuzzy, ignoreHomonyms);
    }

    public String searchForLSID(String name, RankType rank) throws SearchResultException {
        return this.searchForLSID(name, null, rank, false, false);
    }

    @Deprecated
    public String searchForLSID(String name, String kingdom, String scientificName, RankType rank) throws SearchResultException {
        LinnaeanRankClassification cl = new LinnaeanRankClassification(kingdom, scientificName);
        return this.searchForLSID(name, cl, rank, false, false);
    }

    public String searchForLSID(String name, LinnaeanRankClassification cl, RankType rank, boolean fuzzy, boolean ignoreHomonym) throws SearchResultException {
        String lsid = null;
        NameSearchResult result = this.searchForRecord(name, cl, rank, fuzzy, ignoreHomonym);
        if (result != null) {
            if (result.getAcceptedLsid() == null && result.getLsid() == null) {
                this.log.warn((Object)("LSID missing for [name=" + name + ", id=" + result.getId() + "]"));
            } else {
                lsid = result.getAcceptedLsid() != null ? result.getAcceptedLsid() : result.getLsid();
            }
        }
        return lsid;
    }

    public String searchForLSID(LinnaeanRankClassification cl, boolean recursiveMatching) throws SearchResultException {
        NameSearchResult nsr = this.searchForRecord(cl, recursiveMatching);
        if (nsr != null) {
            return nsr.getLsid();
        }
        return null;
    }

    public void updateClassificationWithGUID(LinnaeanRankClassification cl) {
        if (cl.getKid() != null) {
            cl.setKid(this.searchForLsidById(cl.getKid()));
        }
        if (cl.getPid() != null) {
            cl.setPid(this.searchForLsidById(cl.getPid()));
        }
        if (cl.getCid() != null) {
            cl.setCid(this.searchForLsidById(cl.getCid()));
        }
        if (cl.getOid() != null) {
            cl.setOid(this.searchForLsidById(cl.getOid()));
        }
        if (cl.getFid() != null) {
            cl.setFid(this.searchForLsidById(cl.getFid()));
        }
        if (cl.getGid() != null) {
            cl.setGid(this.searchForLsidById(cl.getGid()));
        }
        if (cl.getSid() != null) {
            cl.setSid(this.searchForLsidById(cl.getSid()));
        }
    }

    public NameSearchResult searchForRecord(LinnaeanRankClassification cl, boolean recursiveMatching) throws SearchResultException {
        return this.searchForRecord(cl, recursiveMatching, false, false);
    }

    public MetricsResultDTO searchForRecordMetrics(LinnaeanRankClassification cl, boolean recursiveMatching) throws SearchResultException {
        return this.searchForRecordMetrics(cl, recursiveMatching, false, false);
    }

    public MetricsResultDTO searchForRecordMetrics(LinnaeanRankClassification cl, boolean recursiveMatching, boolean fuzzy) throws SearchResultException {
        return this.searchForRecordMetrics(cl, recursiveMatching, false, fuzzy);
    }

    public NameSearchResult searchForRecord(LinnaeanRankClassification cl, boolean recursiveMatching, boolean fuzzy) throws SearchResultException {
        return this.searchForRecord(cl, recursiveMatching, false, fuzzy);
    }

    public NameSearchResult searchForRecord(LinnaeanRankClassification cl, boolean recursiveMatching, boolean addGuids, boolean fuzzy) throws SearchResultException {
        MetricsResultDTO res = this.searchForRecordMetrics(cl, recursiveMatching, addGuids, fuzzy);
        if (res.getLastException() != null) {
            throw res.getLastException();
        }
        return res.getResult();
    }

    public MetricsResultDTO searchForRecordMetrics(LinnaeanRankClassification cl, boolean recursiveMatching, boolean addGuids, boolean fuzzy) {
        return this.searchForRecordMetrics(cl, recursiveMatching, addGuids, fuzzy, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MetricsResultDTO searchForRecordMetrics(LinnaeanRankClassification cl, boolean recursiveMatching, boolean addGuids, boolean fuzzy, boolean ignoreHomonym) {
        NameSearchResult nsr;
        String originalName;
        String name;
        RankType rank;
        MetricsResultDTO metrics;
        block70: {
            metrics = new MetricsResultDTO();
            rank = cl.getRank() != null ? RankType.getForStrRank(cl.getRank()) : null;
            originalName = name = cl.getScientificName();
            nsr = null;
            metrics.setErrors(new HashSet<ErrorType>());
            if (name == null) {
                if (StringUtils.isNotEmpty((String)cl.getInfraspecificEpithet()) && !this.isInfraSpecificMarker(cl.getSubspecies())) {
                    rank = RankType.SUBSPECIES;
                    if (StringUtils.isNotEmpty((String)cl.getGenus()) && StringUtils.isNotEmpty((String)cl.getSpecificEpithet())) {
                        name = cl.getGenus() + " " + cl.getSpecificEpithet() + " " + cl.getInfraspecificEpithet();
                    }
                } else if (StringUtils.isNotEmpty((String)cl.getSubspecies()) && !this.isInfraSpecificMarker(cl.getSubspecies())) {
                    rank = RankType.SUBSPECIES;
                    name = cl.getSubspecies();
                } else if (StringUtils.isNotEmpty((String)cl.getSpecificEpithet()) && !this.isSpecificMarker(cl.getSpecies())) {
                    rank = RankType.SPECIES;
                    if (StringUtils.isNotEmpty((String)cl.getGenus())) {
                        name = cl.getGenus() + " " + cl.getSpecificEpithet();
                    }
                } else if (StringUtils.isNotEmpty((String)cl.getSpecies()) && !this.isSpecificMarker(cl.getSpecies())) {
                    rank = RankType.SPECIES;
                    name = cl.getSpecies();
                    if (!name.trim().contains(" ")) {
                        name = StringUtils.isNotEmpty((String)cl.getGenus()) ? cl.getGenus() + " " + cl.getSpecificEpithet() : null;
                    }
                } else if (StringUtils.isNotEmpty((String)cl.getGenus())) {
                    rank = RankType.GENUS;
                    name = cl.getGenus();
                } else if (StringUtils.isNotEmpty((String)cl.getFamily())) {
                    rank = RankType.FAMILY;
                    name = cl.getFamily();
                } else if (StringUtils.isNotEmpty((String)cl.getOrder())) {
                    rank = RankType.ORDER;
                    name = cl.getOrder();
                } else if (StringUtils.isNotEmpty((String)cl.getKlass())) {
                    rank = RankType.CLASS;
                    name = cl.getKlass();
                } else if (StringUtils.isNotEmpty((String)cl.getPhylum())) {
                    rank = RankType.PHYLUM;
                    name = cl.getPhylum();
                } else if (StringUtils.isNotEmpty((String)cl.getKingdom())) {
                    rank = RankType.KINGDOM;
                    name = cl.getKingdom();
                }
                originalName = name;
            } else {
                if (rank == null && StringUtils.equalsIgnoreCase((String)name, (String)cl.getSubspecies())) {
                    rank = RankType.SUBSPECIES;
                } else if (rank == null && StringUtils.equalsIgnoreCase((String)name, (String)cl.getSpecies())) {
                    rank = RankType.SPECIES;
                } else if (rank == null && StringUtils.equalsIgnoreCase((String)name, (String)cl.getGenus())) {
                    rank = RankType.GENUS;
                } else if (rank == null && StringUtils.equalsIgnoreCase((String)name, (String)cl.getFamily())) {
                    rank = RankType.FAMILY;
                } else if (rank == null && StringUtils.equalsIgnoreCase((String)name, (String)cl.getOrder())) {
                    rank = RankType.ORDER;
                } else if (rank == null && StringUtils.equalsIgnoreCase((String)name, (String)cl.getKlass())) {
                    rank = RankType.CLASS;
                } else if (rank == null && StringUtils.equalsIgnoreCase((String)name, (String)cl.getPhylum())) {
                    rank = RankType.PHYLUM;
                } else if (rank == null && StringUtils.equalsIgnoreCase((String)name, (String)cl.getKingdom())) {
                    rank = RankType.KINGDOM;
                }
                if (rank == null) {
                    if (recursiveMatching && (name.endsWith(" sp") || name.endsWith(" sp."))) {
                        name = name.substring(0, name.lastIndexOf(" "));
                        cl.setGenus(name);
                    }
                    try {
                        ParsedName cn = this.parser.parse(name.replaceAll("\\?", ""));
                        if (cn != null && cn.type == NameType.doubtful) {
                            if (recursiveMatching) {
                                name = cn.genusOrAbove;
                                rank = RankType.GENUS;
                                metrics.setNameType(NameType.doubtful);
                            }
                            break block70;
                        }
                        if (cn == null || !cn.isBinomial()) break block70;
                        if (StringUtils.isEmpty((String)cl.getGenus())) {
                            cl.setGenus(cn.genusOrAbove);
                        }
                        if (cn.rank == null && cn.cultivar == null && cn.isParsableType()) {
                            if (cn.getInfraSpecificEpithet() != null) {
                                rank = RankType.SUBSPECIES;
                                if (StringUtils.isEmpty((String)cl.getSpecies())) {
                                    cl.setSpecies(cn.genusOrAbove + " " + cn.specificEpithet);
                                }
                                break block70;
                            }
                            rank = RankType.SPECIES;
                            break block70;
                        }
                        if (cn.cultivar != null) {
                            rank = RankType.CULTIVAR;
                        } else if (cn.rank == null) {
                            // empty if block
                        }
                    }
                    catch (UnparsableException e) {
                        metrics.setNameType(e.type);
                    }
                }
            }
        }
        nsr = this.performErrorCheckSearch(name.replaceAll("\\?", ""), cl, rank, fuzzy, ignoreHomonym, metrics);
        if (nsr == null && recursiveMatching) {
            String authorship = cl.getAuthorship();
            cl.setAuthorship(null);
            try {
                ParsedName pn = this.parser.parse(name);
                metrics.setNameType(pn.getType());
                if (pn.type == NameType.doubtful || rank != null && rank.getId() <= 7000 || rank == null) {
                    nsr = this.performErrorCheckSearch(pn.getGenusOrAbove(), cl, null, fuzzy, ignoreHomonym, metrics);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (nsr == null && rank != RankType.SPECIES && (StringUtils.isNotEmpty((String)cl.getSpecificEpithet()) && !this.isSpecificMarker(cl.getSpecificEpithet()) || StringUtils.isNotEmpty((String)cl.getSpecies()) && !this.isSpecificMarker(cl.getSpecies()))) {
                name = cl.getSpecies();
                if (StringUtils.isEmpty((String)name)) {
                    name = cl.getGenus() + " " + cl.getSpecificEpithet();
                }
                nsr = this.performErrorCheckSearch(name, cl, RankType.SPECIES, fuzzy, ignoreHomonym, metrics);
            }
            if (nsr == null && cl.getGenus() != null) {
                nsr = this.performErrorCheckSearch(cl.getGenus(), cl, RankType.GENUS, fuzzy, ignoreHomonym, metrics);
            }
            if (nsr == null && cl.getFamily() != null) {
                nsr = this.performErrorCheckSearch(cl.getFamily(), cl, RankType.FAMILY, fuzzy, ignoreHomonym, metrics);
            }
            if (nsr == null && cl.getOrder() != null) {
                nsr = this.performErrorCheckSearch(cl.getOrder(), cl, RankType.ORDER, fuzzy, ignoreHomonym, metrics);
            }
            if (nsr == null && cl.getKlass() != null) {
                nsr = this.performErrorCheckSearch(cl.getKlass(), cl, RankType.CLASS, fuzzy, ignoreHomonym, metrics);
            }
            if (nsr == null && cl.getPhylum() != null) {
                nsr = this.performErrorCheckSearch(cl.getPhylum(), cl, RankType.PHYLUM, fuzzy, ignoreHomonym, metrics);
            }
            if (nsr == null && cl.getKingdom() != null) {
                nsr = this.performErrorCheckSearch(cl.getKingdom(), cl, RankType.KINGDOM, fuzzy, ignoreHomonym, metrics);
            }
            if (nsr != null) {
                nsr.setMatchType(MatchType.RECURSIVE);
            }
            cl.setAuthorship(authorship);
        }
        if (metrics.getNameType() == null) {
            try {
                ParsedName pn = this.parser.parse(originalName);
                metrics.setNameType(pn.type);
            }
            catch (UnparsableException e) {
                metrics.setNameType(e.type);
            }
        }
        this.checkOtherIssues(originalName, metrics);
        if (nsr != null && addGuids) {
            this.updateClassificationWithGUID(nsr.getRankClassification());
        }
        if (metrics.getErrors().size() == 0) {
            metrics.getErrors().add(ErrorType.NONE);
        }
        metrics.setResult(nsr);
        return metrics;
    }

    private void checkOtherIssues(String originalName, MetricsResultDTO metrics) {
        if (originalName.contains("?")) {
            metrics.getErrors().add(ErrorType.QUESTION_SPECIES);
            metrics.setNameType(NameType.doubtful);
        }
        if (cfPattern.matcher(originalName).matches()) {
            metrics.getErrors().add(ErrorType.CONFER_SPECIES);
        }
        if (affPattern.matcher(originalName).matches()) {
            metrics.getErrors().add(ErrorType.AFFINITY_SPECIES);
        }
    }

    private NameSearchResult performErrorCheckSearch(String name, LinnaeanRankClassification cl, RankType rank, boolean fuzzy, boolean ignoreHomonym, MetricsResultDTO metrics) {
        NameSearchResult nsr = null;
        try {
            nsr = this.searchForRecord(name, cl, rank, fuzzy, ignoreHomonym);
        }
        catch (MisappliedException e) {
            metrics.setLastException(e);
            metrics.getErrors().add(e.errorType);
            if (e.getMisappliedResult() != null) {
                nsr = e.getMatchedResult();
            }
        }
        catch (ParentSynonymChildException e) {
            metrics.setLastException(e);
            metrics.getErrors().add(e.errorType);
            nsr = e.getChildResult();
        }
        catch (ExcludedNameException e) {
            metrics.setLastException(e);
            metrics.getErrors().add(e.errorType);
            nsr = e.getNonExcludedName() != null ? e.getNonExcludedName() : e.getExcludedName();
        }
        catch (SearchResultException e) {
            metrics.setLastException(e);
            metrics.getErrors().add(e.errorType);
        }
        return nsr;
    }

    private boolean isInfraSpecificMarker(String subspecies) {
        String epithet = StringUtils.trimToNull((String)subspecies);
        return epithet != null && ("spp".equalsIgnoreCase(epithet) || "spp.".equalsIgnoreCase(epithet));
    }

    private boolean isSpecificMarker(String species) {
        String epithet = StringUtils.trimToNull((String)species);
        return epithet != null && ("sp".equalsIgnoreCase(epithet) || "sp.".equalsIgnoreCase(epithet) || "sp.nov.".equalsIgnoreCase(species.replaceAll(" ", "")));
    }

    public String searchForLSID(String name, LinnaeanRankClassification cl, RankType rank) throws SearchResultException {
        return this.searchForLSID(name, cl, rank, false, false);
    }

    public NameSearchResult searchForRecord(String name, RankType rank, boolean fuzzy) throws SearchResultException {
        return this.searchForRecord(name, null, rank, fuzzy);
    }

    public NameSearchResult searchForRecord(String name) throws SearchResultException {
        return this.searchForRecord(name, null, false);
    }

    public NameSearchResult searchForRecord(String name, RankType rank) throws SearchResultException {
        return this.searchForRecord(name, rank, false);
    }

    public String searchForAcceptedLsidDefaultHandling(LinnaeanRankClassification cl, boolean fuzzy) {
        return this.searchForAcceptedLsidDefaultHandling(cl, fuzzy, false);
    }

    public String searchForAcceptedLsidDefaultHandling(LinnaeanRankClassification cl, boolean fuzzy, boolean ignoreHomonyms) {
        NameSearchResult nsr = this.searchForAcceptedRecordDefaultHandling(cl, fuzzy, ignoreHomonyms);
        if (nsr == null) {
            return null;
        }
        return nsr.getLsid();
    }

    public NameSearchResult searchForAcceptedRecordDefaultHandling(LinnaeanRankClassification cl, boolean fuzzy) {
        return this.searchForAcceptedRecordDefaultHandling(cl, fuzzy, false);
    }

    public NameSearchResult searchForAcceptedRecordDefaultHandling(LinnaeanRankClassification cl, boolean fuzzy, boolean ignoreHomonym) {
        NameSearchResult nsr = null;
        try {
            nsr = this.searchForRecord(cl.getScientificName(), cl, null, fuzzy, ignoreHomonym);
        }
        catch (MisappliedException e) {
            if (e.getMisappliedResult() != null) {
                nsr = e.getMatchedResult();
            }
        }
        catch (ParentSynonymChildException e) {
            nsr = e.getChildResult();
        }
        catch (ExcludedNameException e) {
            nsr = e.getNonExcludedName() != null ? e.getNonExcludedName() : e.getExcludedName();
        }
        catch (SearchResultException e) {
            // empty catch block
        }
        if (nsr != null && nsr.isSynonym()) {
            nsr = this.searchForRecordByLsid(nsr.getAcceptedLsid());
        }
        return nsr;
    }

    @Deprecated
    public NameSearchResult searchForRecord(String name, String kingdom, String genus, RankType rank) throws SearchResultException {
        LinnaeanRankClassification cl = new LinnaeanRankClassification(kingdom, genus);
        return this.searchForRecord(name, cl, rank, false);
    }

    public NameSearchResult searchForRecord(String name, LinnaeanRankClassification cl, RankType rank, boolean fuzzy) throws SearchResultException {
        return this.searchForRecord(name, cl, rank, fuzzy, false);
    }

    public NameSearchResult searchForRecord(String name, LinnaeanRankClassification cl, RankType rank, boolean fuzzy, boolean ignoreHomonyms) throws SearchResultException {
        List<NameSearchResult> results = this.searchForRecords(name, rank, cl, 10, fuzzy, ignoreHomonyms);
        if (results != null && results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public NameSearchResult searchForRecord(String name, LinnaeanRankClassification cl, RankType rank) throws SearchResultException {
        return this.searchForRecord(name, cl, rank, false);
    }

    public NameSearchResult searchForRecordByID(String id) {
        try {
            List<NameSearchResult> results = this.performSearch(ALANameIndexer.IndexField.ID.toString(), id, null, null, 1, null, false, this.idParser.get());
            if (results.size() > 0) {
                results.get(0).setMatchType(MatchType.TAXON_ID);
                return results.get(0);
            }
        }
        catch (SearchResultException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String searchForLsidById(String id) {
        NameSearchResult result = this.searchForRecordByID(id);
        if (result != null) {
            return result.getAcceptedLsid() != null ? result.getAcceptedLsid() : result.getLsid();
        }
        return null;
    }

    public List<NameSearchResult> searchForRecords(String name, RankType rank, boolean fuzzy) throws SearchResultException {
        return this.searchForRecords(name, rank, null, 10, fuzzy);
    }

    public List<NameSearchResult> searchForRecords(String name, RankType rank, LinnaeanRankClassification cl, int max) throws SearchResultException {
        return this.searchForRecords(name, rank, cl, max, false);
    }

    public List<NameSearchResult> searchForRecords(String name, RankType rank, LinnaeanRankClassification cl, int max, boolean fuzzy) throws SearchResultException {
        return this.searchForRecords(name, rank, cl, max, fuzzy, true, false);
    }

    public List<NameSearchResult> searchForRecords(String name, RankType rank, LinnaeanRankClassification cl, int max, boolean fuzzy, boolean ignoreHomonyms) throws SearchResultException {
        return this.searchForRecords(name, rank, cl, max, fuzzy, true, ignoreHomonyms);
    }

    private List<NameSearchResult> searchForRecords(String name, RankType rank, LinnaeanRankClassification cl, int max, boolean fuzzy, boolean clean, boolean ignoreHomonym) throws SearchResultException {
        if (name == null) {
            throw new SearchResultException("Unable to perform search. Null value supplied for the name.");
        }
        if (PhraseNameParser.RANK_MARKER.matcher(name).matches()) {
            throw new SearchResultException("Supplied scientific name is a rank marker.");
        }
        try {
            name = virusStopPattern.matcher(name).replaceAll(" ").trim();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (name.contains("spp.")) {
            throw new SPPException();
        }
        try {
            String voucher;
            String phrase;
            String genus;
            NameType nameType = null;
            ParsedName pn = null;
            try {
                pn = this.parser.parse(name);
                nameType = pn != null ? pn.getType() : null;
            }
            catch (UnparsableException e) {
                this.log.warn((Object)("Unable to parse " + name + ". " + e.getMessage()));
            }
            List<NameSearchResult> hits = this.performSearch(NameIndexField.NAME.toString(), name, rank, cl, max, MatchType.EXACT, true, this.queryParser.get());
            if (hits == null) {
                return null;
            }
            if (hits.size() > 0) {
                return hits;
            }
            if (pn instanceof ALAParsedName) {
                ALAParsedName alapn = (ALAParsedName)pn;
                genus = alapn.getGenusOrAbove();
                phrase = alapn.cleanPhrase;
                voucher = alapn.cleanVoucher;
                String specific = alapn.rank != null && alapn.rank.equals("sp.") ? null : alapn.specificEpithet;
                String[][] searchFields = new String[][]{{RankType.GENUS.getRank(), genus}, {NameIndexField.PHRASE.toString(), phrase}, {NameIndexField.VOUCHER.toString(), voucher}, {NameIndexField.SPECIFIC.toString(), specific}};
                hits = this.performSearch(searchFields, rank, cl, max, MatchType.PHRASE, false, this.queryParser.get());
                if (hits.size() == 1) {
                    return hits;
                }
                if (hits.size() > 1) {
                    NameSearchResult commonAccepted = this.getCommonAccepetedConcept(hits);
                    if (commonAccepted != null) {
                        hits.removeAll(hits);
                        hits.add(commonAccepted);
                        return hits;
                    }
                    throw new HomonymException(hits);
                }
            } else if (pn != null && pn.isParsableType() && pn.authorsParsed && pn.getType() != NameType.informal && pn.getType() != NameType.doubtful) {
                String canonicalName = pn.canonicalName();
                if (cl == null) {
                    cl = new LinnaeanRankClassification();
                }
                if (cl.getAuthorship() == null) {
                    cl.setAuthorship(pn.authorshipComplete());
                }
                if ((hits = this.performSearch(ALANameIndexer.IndexField.NAME.toString(), canonicalName, rank, cl, max, MatchType.CANONICAL, true, this.queryParser.get())).size() > 0) {
                    return hits;
                }
                if (pn.getType() == NameType.cultivar) {
                    genus = pn.getGenusOrAbove();
                    phrase = pn.getCultivar();
                    voucher = null;
                    String specific = pn.rank != null && pn.rank.equals("sp.") ? null : pn.getSpecificEpithet();
                    String[][] searchFields = new String[][]{{RankType.GENUS.getRank(), genus}, {NameIndexField.PHRASE.toString(), phrase}, {NameIndexField.VOUCHER.toString(), voucher}, {NameIndexField.SPECIFIC.toString(), specific}};
                    hits = this.performSearch(searchFields, rank, cl, max, MatchType.PHRASE, false, this.queryParser.get());
                    if (hits.size() > 0) {
                        return hits;
                    }
                }
            }
            if (pn != null && fuzzy && pn.isBinomial() && pn.getType() != NameType.informal && pn.getType() != NameType.doubtful) {
                String genus2 = TaxonNameSoundEx.treatWord(pn.genusOrAbove, "genus");
                String specific = TaxonNameSoundEx.treatWord(pn.specificEpithet, "species");
                String infra = pn.infraSpecificEpithet == null ? null : TaxonNameSoundEx.treatWord(pn.infraSpecificEpithet, "species");
                String[][] searchFields = new String[][]{{NameIndexField.GENUS_EX.toString(), genus2}, {NameIndexField.SPECIES_EX.toString(), specific}, StringUtils.isNotEmpty((String)infra) ? new String[]{NameIndexField.INFRA_EX.toString(), infra} : new String[]{NameIndexField.INFRA_EX.toString(), "<null>"}};
                hits = this.performSearch(searchFields, rank, cl, max, MatchType.SOUNDEX, false, this.queryParser.get());
                if (hits.size() > 0) {
                    return hits;
                }
            }
            return null;
        }
        catch (HomonymException e) {
            if (ignoreHomonym && e.getResults().size() == 1) {
                return e.getResults();
            }
            throw e;
        }
        catch (IOException e) {
            this.log.warn((Object)e.getMessage());
            return null;
        }
    }

    private NameSearchResult getCommonAccepetedConcept(List<NameSearchResult> hits) {
        String acceptedLsid = hits.get(0).getAcceptedLsid();
        for (NameSearchResult hit : hits) {
            if (hit.getAcceptedLsid() == null) {
                return null;
            }
            if (hit.getAcceptedLsid().equals(acceptedLsid)) continue;
            return null;
        }
        if (acceptedLsid != null) {
            return this.searchForRecordByLsid(acceptedLsid);
        }
        return null;
    }

    private List<NameSearchResult> performSearch(String field, String value, RankType rank, LinnaeanRankClassification cl, int max, MatchType type, boolean checkHomo, QueryParser parser) throws IOException, SearchResultException {
        String[][] compValues = new String[][]{{field, value}};
        return this.performSearch(compValues, rank, cl, max, type, checkHomo, parser);
    }

    private List<NameSearchResult> performSearch(String[][] compulsoryValues, RankType rank, LinnaeanRankClassification cl, int max, MatchType type, boolean checkHomo, QueryParser parser) throws IOException, SearchResultException {
        if (this.cbSearcher != null) {
            String scientificName = null;
            StringBuilder query = new StringBuilder();
            for (String[] values : compulsoryValues) {
                if (values[1] == null) continue;
                query.append("+" + values[0] + ":\"" + values[1] + "\"");
                if (!values[0].equals(NameIndexField.NAME.toString())) continue;
                scientificName = values[1];
            }
            if (rank != null) {
                query.append("+(");
                if (rank.getId() >= RankType.SPECIES.getId()) {
                    query.append(NameIndexField.RANK_ID.toString()).append(":[7000 TO 9999]");
                } else {
                    query.append(NameIndexField.RANK.toString() + ":" + rank.getRank());
                }
                query.append(" OR ").append(NameIndexField.iS_SYNONYM.toString()).append(":T OR ").append((Object)NameIndexField.ALA).append(":T)");
            }
            if (cl != null) {
                query.append(cl.getLuceneSearchString(true));
            }
            try {
                TopDocs hits = this.cbSearcher.search(parser.parse(query.toString()), max);
                ArrayList<NameSearchResult> results = new ArrayList<NameSearchResult>();
                for (ScoreDoc sdoc : hits.scoreDocs) {
                    NameSearchResult nsr = new NameSearchResult(this.cbReader.document(sdoc.doc), type);
                    results.add(nsr);
                }
                if (checkHomo) {
                    RankType resRank;
                    if (results.size() > 0) {
                        int exclCount = 0;
                        NameSearchResult notExcludedResult = null;
                        NameSearchResult excludedResult = null;
                        for (NameSearchResult nsr : results) {
                            if (nsr.getSynonymType() == SynonymType.EXCLUDES) {
                                ++exclCount;
                                excludedResult = nsr;
                                continue;
                            }
                            if (notExcludedResult != null) continue;
                            notExcludedResult = nsr;
                        }
                        if (exclCount > 0) {
                            if (exclCount == results.size()) {
                                throw new ExcludedNameException("The result is a name that has been excluded from the NSL", excludedResult);
                            }
                            if (notExcludedResult != null) {
                                throw new ExcludedNameException("One of the results was excluded.  Use the nonExcludedName for your match.", notExcludedResult, excludedResult);
                            }
                        }
                    }
                    this.checkForSpeciesSplit(results);
                    this.checkForMisapplied(results);
                    if (rank == null) {
                        this.checkForCrossRankHomonym(results);
                    }
                    if (results.size() > 0 && ((resRank = ((NameSearchResult)results.get(0)).getRank()) == RankType.GENUS || resRank == RankType.SPECIES || ((NameSearchResult)results.get(0)).isSynonym() && (rank == null || rank == RankType.GENUS || rank == RankType.SPECIES))) {
                        NameSearchResult result = cl != null && StringUtils.isNotBlank((String)cl.getAuthorship()) ? this.validateHomonymByAuthor(results, scientificName, cl) : this.validateHomonyms(results, scientificName, cl);
                        results.clear();
                        results.add(result);
                    }
                }
                return results;
            }
            catch (ParseException e) {
                throw new SearchResultException("Error parsing " + query.toString() + "." + e.getMessage());
            }
        }
        return null;
    }

    private void checkResultLevelHomonym(List<NameSearchResult> results) throws HomonymException {
        if (results.size() > 1) {
            String lastAcceptedLsid = "";
            String lastKingdom = "";
            boolean lastWasSyn = false;
            for (NameSearchResult result : results) {
                String kingdom;
                if (!result.isSynonym() && result.getRank().getId() < 7000) continue;
                String accepted = result.isSynonym() ? result.getAcceptedLsid() : result.getLsid();
                String string = kingdom = result.getRankClassification().getKingdom() == null ? "" : result.getRankClassification().getKingdom();
                if (lastAcceptedLsid.length() > 0 && !lastAcceptedLsid.equals(accepted) && (lastKingdom.equals(kingdom) || lastWasSyn || result.isSynonym())) {
                    throw new HomonymException(accepted, results);
                }
                lastAcceptedLsid = accepted;
                lastWasSyn = result.isSynonym();
            }
        }
    }

    private void checkForMisapplied(List<NameSearchResult> results) throws MisappliedException {
        if (results.size() >= 1) {
            NameSearchResult second;
            NameSearchResult first = results.get(0);
            NameSearchResult nameSearchResult = second = results.size() > 1 ? results.get(1) : null;
            if (first.getSynonymType() == SynonymType.MISAPPLIED) {
                NameSearchResult accepted = this.searchForRecordByLsid(first.getAcceptedLsid());
                throw new MisappliedException(accepted);
            }
            if (!first.isSynonym() && second != null && second.getSynonymType() == SynonymType.MISAPPLIED) {
                NameSearchResult accepted = this.searchForRecordByLsid(second.getAcceptedLsid());
                throw new MisappliedException(first, accepted);
            }
        }
    }

    private void checkForSpeciesSplit(List<NameSearchResult> results) throws ParentSynonymChildException {
        if (results.size() == 2) {
            if (results.get(0).isSynonym() != results.get(1).isSynonym() && (!results.get(0).isSynonym() && results.get(0).getRank() == RankType.SPECIES || !results.get(1).isSynonym() && results.get(1).getRank() == RankType.SPECIES)) {
                int asyLeft;
                NameSearchResult synResult = results.get(0).isSynonym() ? results.get(0) : results.get(1);
                NameSearchResult accResult = results.get(0).isSynonym() ? results.get(1) : results.get(0);
                NameSearchResult accSynResult = this.searchForRecordByLsid(synResult.getAcceptedLsid());
                if (accResult.getLeft() != null && accSynResult.getLeft() != null && (asyLeft = Integer.parseInt(accSynResult.getLeft())) > Integer.parseInt(accResult.getLeft()) && asyLeft < Integer.parseInt(accResult.getRight())) {
                    throw new ParentSynonymChildException(accResult, accSynResult);
                }
            }
        } else if (results.size() > 2) {
            NameSearchResult accResult = null;
            String acceptedLsid = null;
            for (NameSearchResult nsr : results) {
                if (!nsr.isSynonym()) {
                    if (accResult == null) {
                        accResult = nsr;
                        continue;
                    }
                    return;
                }
                if (acceptedLsid != null) {
                    if (acceptedLsid.equals(nsr.getAcceptedLsid())) continue;
                    return;
                }
                acceptedLsid = nsr.getAcceptedLsid();
            }
            if (accResult != null && acceptedLsid != null) {
                int asyLeft;
                NameSearchResult accSynResult = this.searchForRecordByLsid(acceptedLsid);
                if (accResult.getLeft() != null && accSynResult.getLeft() != null && (asyLeft = Integer.parseInt(accSynResult.getLeft())) > Integer.parseInt(accResult.getLeft()) && asyLeft < Integer.parseInt(accResult.getRight())) {
                    throw new ParentSynonymChildException(accResult, accSynResult);
                }
            }
        }
    }

    private void checkForCrossRankHomonym(List<NameSearchResult> results) throws HomonymException {
        if (results != null && results.size() > 0 && this.crossRankHomonyms.contains(results.get(0).getRankClassification().getScientificName().toLowerCase())) {
            throw new HomonymException("Cross rank homonym detected.  Please repeat search with a rank specified.", results);
        }
    }

    public NameSearchResult validateHomonymByAuthor(List<NameSearchResult> result, String name, LinnaeanRankClassification cl) throws HomonymException {
        String suppliedAuthor = this.prepareAuthor(cl.getAuthorship());
        String resultAuthor = result.get(0).getRankClassification().getAuthorship();
        SmithWatermanGotoh similarity = new SmithWatermanGotoh();
        if (resultAuthor == null || (double)similarity.getSimilarity(suppliedAuthor, resultAuthor) < 0.8) {
            this.validateHomonyms(result, name, cl);
        }
        return result.get(0);
    }

    private String prepareAuthor(String author) {
        return author.replaceAll("\\p{P}", "").replaceAll("\\p{Z}", "");
    }

    public NameSearchResult validateHomonyms(List<NameSearchResult> results, String name, LinnaeanRankClassification cl) throws HomonymException {
        RankType rank = results.get(0).getRank();
        try {
            if (rank == null && results.get(0).isSynonym()) {
                cl = new LinnaeanRankClassification(null, null);
                String synName = results.get(0).getRankClassification().getScientificName();
                try {
                    ParsedName pn = this.parser.parse(synName);
                    if (pn.isBinomial()) {
                        cl.setSpecies(pn.canonicalName());
                        rank = RankType.SPECIES;
                    } else {
                        cl.setGenus(pn.genusOrAbove);
                        rank = RankType.GENUS;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (cl == null) {
                if (rank == RankType.GENUS) {
                    cl = new LinnaeanRankClassification(null, name);
                } else if (rank == RankType.SPECIES) {
                    cl = new LinnaeanRankClassification(null, null);
                    cl.setSpecies(name);
                }
            }
            if (rank == RankType.GENUS && cl.getGenus() == null) {
                cl.setGenus(name);
            } else if (rank == RankType.SPECIES && cl.getSpecies() == null) {
                cl.setSpecies(name);
            }
            RankType resolveLevel = this.resolveIRMNGHomonym(cl, rank);
            if (resolveLevel == null) {
                return results.get(0);
            }
            this.log.debug((Object)("resolve the homonym at " + (Object)((Object)resolveLevel) + " rank"));
            for (NameSearchResult result : results) {
                if (result.isSynonym() || !cl.hasIdenticalClassification(result.getRankClassification(), resolveLevel)) continue;
                return result;
            }
            throw new HomonymException(results);
        }
        catch (HomonymException e) {
            e.setResults(results);
            throw e;
        }
    }

    private boolean isHomonymResolvable(LinnaeanRankClassification cl) {
        TopDocs results = this.getIRMNGGenus(cl, RankType.GENUS);
        if (results != null) {
            return results.totalHits <= 1;
        }
        return false;
    }

    public TopDocs getIRMNGGenus(LinnaeanRankClassification cl, RankType rank) {
        if (cl != null && (cl.getGenus() != null || cl.getSpecies() != null)) {
            try {
                String searchString = "+rank:" + (Object)((Object)rank) + " " + cl.getLuceneSearchString(false).trim();
                this.log.debug((Object)("Search string : " + searchString + " classification : " + cl));
                Query query = this.queryParser.get().parse(searchString);
                this.log.debug((Object)("getIRMNG query: " + query.toString()));
                return this.irmngSearcher.search(query, 10);
            }
            catch (Exception e) {
                this.log.warn((Object)"Error searching IRMNG index.", (Throwable)e);
            }
        }
        return null;
    }

    public RankType resolveIRMNGHomonym(LinnaeanRankClassification cl, RankType rank) throws HomonymException {
        if (cl.getGenus() != null || cl.getSpecies() != null) {
            LinnaeanRankClassification newcl = new LinnaeanRankClassification(null, cl.getGenus());
            if (rank == RankType.SPECIES) {
                newcl.setSpecies(cl.getSpecies());
            }
            if (cl != null && (cl.getGenus() != null || cl.getSpecies() != null)) {
                TopDocs results = this.getIRMNGGenus(newcl, rank);
                if (results == null || results.totalHits <= 1) {
                    return null;
                }
                if (cl != null && cl.getKingdom() != null) {
                    newcl.setKingdom(cl.getKingdom());
                    results = this.getIRMNGGenus(newcl, rank);
                    if (results.totalHits == 1) {
                        return RankType.KINGDOM;
                    }
                }
                if (cl.getPhylum() != null && results.totalHits > 1) {
                    newcl.setPhylum(cl.getPhylum());
                    results = this.getIRMNGGenus(newcl, rank);
                    if (results.totalHits == 1) {
                        return RankType.PHYLUM;
                    }
                    if (results.totalHits == 0) {
                        newcl.setPhylum(null);
                    }
                }
                if (cl.getKlass() != null) {
                    newcl.setKlass(cl.getKlass());
                    results = this.getIRMNGGenus(newcl, rank);
                    if (results.totalHits == 1) {
                        return RankType.CLASS;
                    }
                }
                if (cl.getOrder() != null && results.totalHits > 1) {
                    newcl.setOrder(cl.getOrder());
                    results = this.getIRMNGGenus(newcl, rank);
                    if (results.totalHits == 1) {
                        return RankType.ORDER;
                    }
                }
                if (cl.getFamily() != null && results.totalHits > 1) {
                    newcl.setFamily(cl.getFamily());
                    results = this.getIRMNGGenus(newcl, rank);
                    if (results.totalHits == 1) {
                        return RankType.FAMILY;
                    }
                }
            }
        }
        throw new HomonymException("Problem resolving the classification: " + cl);
    }

    public String searchForLSIDCommonName(String commonName) {
        return this.getLSIDForUniqueCommonName(commonName);
    }

    public String getCommonNameForLSID(String lsid) {
        if (lsid != null) {
            TermQuery query = new TermQuery(new Term(ALANameIndexer.IndexField.LSID.toString(), lsid));
            try {
                TopDocs results = this.vernSearcher.search((Query)query, 1);
                this.log.debug((Object)("Number of matches for " + lsid + " " + results.totalHits));
                ScoreDoc[] arr$ = results.scoreDocs;
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ScoreDoc sdoc = arr$[i$];
                    Document doc = this.vernSearcher.doc(sdoc.doc);
                    return doc.get(ALANameIndexer.IndexField.COMMON_NAME.toString());
                }
            }
            catch (IOException e) {
                this.log.debug((Object)"Unable to access document for common name.", (Throwable)e);
            }
        }
        return null;
    }

    public Set<String> getCommonNamesForLSID(String lsid, int maxNumberOfNames) {
        if (lsid != null) {
            TermQuery query = new TermQuery(new Term(ALANameIndexer.IndexField.LSID.toString(), lsid));
            try {
                TopDocs results = this.vernSearcher.search((Query)query, maxNumberOfNames);
                this.log.debug((Object)("Number of matches for " + lsid + " " + results.totalHits));
                HashSet<String> names = new HashSet<String>();
                HashSet<String> lowerCaseResults = new HashSet<String>();
                int idx = 0;
                for (ScoreDoc sdoc : results.scoreDocs) {
                    Document doc = this.vernSearcher.doc(sdoc.doc);
                    String name = doc.get(ALANameIndexer.IndexField.COMMON_NAME.toString());
                    if (!lowerCaseResults.contains(name.toLowerCase())) {
                        lowerCaseResults.add(name.toLowerCase());
                        names.add(name);
                    }
                    ++idx;
                }
                return names;
            }
            catch (IOException e) {
                this.log.debug((Object)"Unable to access document for common name.", (Throwable)e);
            }
        }
        return new HashSet<String>();
    }

    private String getLSIDForUniqueCommonName(String name) {
        if (name != null) {
            TermQuery query = new TermQuery(new Term(ALANameIndexer.IndexField.SEARCHABLE_COMMON_NAME.toString(), name.toUpperCase().replaceAll("[^A-Z0-9\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152]", "")));
            try {
                TopDocs results = this.vernSearcher.search((Query)query, 10);
                String firstLsid = null;
                String firstName = null;
                this.log.debug((Object)("Number of matches for " + name + " " + results.totalHits));
                for (ScoreDoc sdoc : results.scoreDocs) {
                    Document doc = this.vernSearcher.doc(sdoc.doc);
                    if (firstLsid == null) {
                        firstLsid = doc.get(ALANameIndexer.IndexField.LSID.toString());
                        firstName = doc.get(ALANameIndexer.IndexField.NAME.toString());
                        continue;
                    }
                    if (this.doSciNamesMatch(firstName, doc.get(ALANameIndexer.IndexField.NAME.toString()))) continue;
                    return null;
                }
                return this.getPrimaryLsid(firstLsid);
            }
            catch (IOException e) {
                this.log.debug((Object)"Unable to access document for common name.", (Throwable)e);
            }
        }
        return null;
    }

    private boolean doSciNamesMatch(String n1, String n2) {
        try {
            ParsedName pn1 = this.parser.parse(n1);
            ParsedName pn2 = this.parser.parse(n2);
            if (pn1 != null && pn2 != null) {
                return pn1.canonicalName().equals(pn2.canonicalName());
            }
            return false;
        }
        catch (UnparsableException e) {
            return false;
        }
    }

    public NameSearchResult searchForCommonName(String name) {
        NameSearchResult result = null;
        String lsid = this.getLSIDForUniqueCommonName(name);
        if (lsid != null && (result = this.searchForRecordByLsid(lsid)) != null) {
            result.setMatchType(MatchType.VERNACULAR);
        }
        return result;
    }

    public String getPrimaryLsid(String lsid) {
        if (lsid != null) {
            TermQuery tq = new TermQuery(new Term("lsid", lsid));
            try {
                TopDocs results = this.idSearcher.search((Query)tq, 1);
                if (results.totalHits > 0) {
                    return this.idSearcher.doc(results.scoreDocs[0].doc).get("reallsid");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return lsid;
    }

    public NameSearchResult searchForRecordByLsid(String lsid) {
        NameSearchResult result = null;
        try {
            List<NameSearchResult> results = this.performSearch(ALANameIndexer.IndexField.LSID.toString(), lsid, null, null, 1, MatchType.DIRECT, false, this.idParser.get());
            if (results.size() > 0) {
                result = results.get(0);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to search for record by LSID");
        }
        if (result != null) {
            result.setMatchType(MatchType.TAXON_ID);
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        ALANameSearcher nameindex = new ALANameSearcher(args[0]);
        String name = nameindex.getCommonNameForLSID("urn:lsid:biodiversity.org.au:afd.taxon:31a9b8b8-4e8f-4343-a15f-2ed24e0bf1ae");
        System.out.println(name);
        Set<String> names = nameindex.getCommonNamesForLSID("urn:lsid:biodiversity.org.au:apni.taxon:295861", 100);
        for (String commonName : names) {
            System.out.println(commonName);
        }
    }
}

