/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.file;

import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesUtil.class);

    private ResourcesUtil() {
    }

    public static void copy(File folder, String classpathPrefix, boolean ignoreMissingResources, String ... classpathResources) throws IOException {
        for (String classpathResource : classpathResources) {
            String res = classpathPrefix + classpathResource;
            URL url = null;
            try {
                url = Resources.getResource((String)res);
                if (url == null) {
                    throw new IllegalArgumentException("Classpath resource " + res + " not existing");
                }
            }
            catch (IllegalArgumentException e) {
                if (ignoreMissingResources) {
                    LOG.debug("Resource {} not found", (Object)res);
                    continue;
                }
                throw new IOException(e);
            }
            File f = new File(folder, classpathResource);
            Files.createParentDirs((File)f);
            FileOutputStream out = new FileOutputStream(f);
            Resources.copy((URL)url, (OutputStream)out);
            Closeables.closeQuietly((Closeable)out);
        }
    }
}

