/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.tokenisers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import uk.ac.shef.wit.simmetrics.tokenisers.InterfaceTokeniser;
import uk.ac.shef.wit.simmetrics.wordhandlers.DummyStopTermHandler;
import uk.ac.shef.wit.simmetrics.wordhandlers.InterfaceTermHandler;

public final class TokeniserQGram3Extended
implements InterfaceTokeniser,
Serializable {
    private InterfaceTermHandler stopWordHandler = new DummyStopTermHandler();
    private final char QGRAMSTARTPADDING = (char)35;
    private final char QGRAMENDPADDING = (char)35;

    @Override
    public final String getShortDescriptionString() {
        return "TokeniserQGram3Extended";
    }

    @Override
    public final String getDelimiters() {
        return "";
    }

    @Override
    public final ArrayList<String> tokenizeToArrayList(String input) {
        ArrayList<String> returnVect = new ArrayList<String>();
        StringBuffer adjustedString = new StringBuffer();
        adjustedString.append('#');
        adjustedString.append('#');
        adjustedString.append(input);
        adjustedString.append('#');
        adjustedString.append('#');
        int length = adjustedString.length() - 2;
        for (int curPos = 0; curPos < length; ++curPos) {
            String term = adjustedString.substring(curPos, curPos + 3);
            if (this.stopWordHandler.isWord(term)) continue;
            returnVect.add(term);
        }
        return returnVect;
    }

    @Override
    public InterfaceTermHandler getStopWordHandler() {
        return this.stopWordHandler;
    }

    @Override
    public void setStopWordHandler(InterfaceTermHandler stopWordHandler) {
        this.stopWordHandler = stopWordHandler;
    }

    @Override
    public Set<String> tokenizeToSet(String input) {
        HashSet<String> returnSet = new HashSet<String>();
        returnSet.addAll(this.tokenizeToArrayList(input));
        return returnSet;
    }
}

