/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.voc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.ecat.utils.StringLengthComparator;
import org.gbif.ecat.voc.KnownTerm;
import org.gbif.ecat.voc.TermType;

public enum Rank implements KnownTerm
{
    Domain(0, "dom."),
    KINGDOM(25, "king."),
    Subkingdom(50, "subking."),
    Superphylum(60, "superphyl."),
    PHYLUM(75, "phyl."),
    Subphylum(100, "subphyl."),
    Superclass(125, "supercl."),
    CLASS(150, "cl."),
    Subclass(175, "subcl."),
    Superorder(200, "superord."),
    ORDER(225, "ord."),
    Suborder(250, "subord."),
    Infraorder(275, null),
    Superfamily(300, "superfam."),
    FAMILY(325, "fam."),
    Subfamily(350, "subfam."),
    Tribe(375, "trib."),
    Subtribe(400, "subtrib."),
    SupragenericName(410, "supergen."),
    GENUS(425, "gen."),
    SUBGENUS(450, "subgen."),
    Section(475, "sect."),
    Subsection(500, "subsect."),
    Series(525, "ser."),
    Subseries(550, "subser."),
    InfragenericName(575, "infragen."),
    SPECIES(600, "sp."),
    InfraspecificName(625, "agg."),
    SUBSPECIES(650, "subsp."),
    InfrasubspecificName(675, "infrasubsp."),
    VARIETY(700, "var."),
    Subvariety(725, "subvar."),
    Form(750, "f."),
    Subform(775, "subf."),
    CultivarGroup(800, null),
    Cultivar(825, "cv."),
    Strain(835, "strain"),
    Informal(850, null),
    Unranked(875, null);

    private final int id;
    public final String marker;
    private static final int ID_BASE = 0;
    public static final Rank[] KINGDOM_TO_SUBGENUS;
    public static final Rank[] LINNEAN_RANKS;
    public static final Set<Rank> MAYOR_RANKS;
    public static final Set<Rank> UNCOMPARABLE_RANKS;
    public static final Set<Rank> SPECIES_OR_BELOW;
    public static final Set<Rank> SUPRAGENERIC;
    public static final Map<String, Rank> RANK_MARKER_MAP_SUPRAGENERIC;
    public static final Map<String, Rank> RANK_MARKER_MAP_INFRAGENERIC;
    public static final Map<String, Rank> RANK_MARKER_MAP_INFRASPECIFIC;
    public static final Map<String, Rank> RANK_MARKER_MAP;
    public static final SortedMap<String, Rank> SUFFICES_RANK_MAP;

    private Rank(int id, String marker) {
        this.id = id;
        this.marker = marker;
    }

    public static Rank fromAbbreviation(String rankAbbreviation) {
        if (rankAbbreviation.equalsIgnoreCase("k")) {
            return KINGDOM;
        }
        if (rankAbbreviation.equalsIgnoreCase("sk")) {
            return Subkingdom;
        }
        if (rankAbbreviation.equalsIgnoreCase("p")) {
            return PHYLUM;
        }
        if (rankAbbreviation.equalsIgnoreCase("sp")) {
            return Subphylum;
        }
        if (rankAbbreviation.equalsIgnoreCase("c")) {
            return CLASS;
        }
        if (rankAbbreviation.equalsIgnoreCase("sc")) {
            return Subclass;
        }
        if (rankAbbreviation.equalsIgnoreCase("o")) {
            return ORDER;
        }
        if (rankAbbreviation.equalsIgnoreCase("so")) {
            return Suborder;
        }
        if (rankAbbreviation.equalsIgnoreCase("f")) {
            return FAMILY;
        }
        if (rankAbbreviation.equalsIgnoreCase("sf")) {
            return Subfamily;
        }
        if (rankAbbreviation.equalsIgnoreCase("g")) {
            return GENUS;
        }
        if (rankAbbreviation.equalsIgnoreCase("sg")) {
            return SUBGENUS;
        }
        if (rankAbbreviation.equalsIgnoreCase("s")) {
            return SPECIES;
        }
        if (rankAbbreviation.equalsIgnoreCase("ss")) {
            return SUBSPECIES;
        }
        if (rankAbbreviation.equalsIgnoreCase("v")) {
            return VARIETY;
        }
        if (rankAbbreviation.equalsIgnoreCase("ff")) {
            return Form;
        }
        return null;
    }

    public static Rank fromDwcTerm(DwcTerm higherRankTerm) {
        if (higherRankTerm == DwcTerm.kingdom) {
            return KINGDOM;
        }
        if (higherRankTerm == DwcTerm.phylum) {
            return PHYLUM;
        }
        if (higherRankTerm == DwcTerm.classs) {
            return CLASS;
        }
        if (higherRankTerm == DwcTerm.order) {
            return ORDER;
        }
        if (higherRankTerm == DwcTerm.family) {
            return FAMILY;
        }
        if (higherRankTerm == DwcTerm.genus) {
            return GENUS;
        }
        if (higherRankTerm == DwcTerm.subgenus) {
            return SUBGENUS;
        }
        return null;
    }

    public static Rank inferRank(String genusOrAbove, String infraGeneric, String specificEpithet, String rankMarker, String infraSpecificEpithet) {
        Rank markerRank = Rank.inferRankMarker(rankMarker);
        if (markerRank != null) {
            return markerRank;
        }
        Rank rank = Unranked;
        if (infraSpecificEpithet != null) {
            rank = InfraspecificName;
        } else if (specificEpithet != null) {
            rank = SPECIES;
        } else if (infraGeneric != null) {
            rank = InfragenericName;
        } else if (genusOrAbove != null) {
            for (String suffix : SUFFICES_RANK_MAP.keySet()) {
                if (!genusOrAbove.endsWith(suffix)) continue;
                rank = (Rank)SUFFICES_RANK_MAP.get(suffix);
                break;
            }
        }
        return rank;
    }

    public static Rank inferRankMarker(String rankMarker) {
        Rank markerRank;
        if (rankMarker != null && (markerRank = RANK_MARKER_MAP.get(rankMarker.toLowerCase().replaceAll("[._-]", ""))) != null) {
            return markerRank;
        }
        return null;
    }

    public static String toAbbreviation(Rank mayorRank) {
        if (mayorRank == KINGDOM) {
            return "k";
        }
        if (mayorRank == Subkingdom) {
            return "sk";
        }
        if (mayorRank == PHYLUM) {
            return "p";
        }
        if (mayorRank == Subphylum) {
            return "sp";
        }
        if (mayorRank == CLASS) {
            return "c";
        }
        if (mayorRank == Subclass) {
            return "sc";
        }
        if (mayorRank == ORDER) {
            return "o";
        }
        if (mayorRank == Suborder) {
            return "so";
        }
        if (mayorRank == FAMILY) {
            return "f";
        }
        if (mayorRank == Subfamily) {
            return "sf";
        }
        if (mayorRank == GENUS) {
            return "g";
        }
        if (mayorRank == SUBGENUS) {
            return "sg";
        }
        if (mayorRank == SPECIES) {
            return "s";
        }
        if (mayorRank == InfraspecificName) {
            return "is";
        }
        if (mayorRank == VARIETY) {
            return "v";
        }
        if (mayorRank == Form) {
            return "ff";
        }
        return null;
    }

    public static DwcTerm toDwcTerm(Rank rank) {
        if (rank == KINGDOM) {
            return DwcTerm.kingdom;
        }
        if (rank == PHYLUM) {
            return DwcTerm.phylum;
        }
        if (rank == CLASS) {
            return DwcTerm.classs;
        }
        if (rank == ORDER) {
            return DwcTerm.order;
        }
        if (rank == FAMILY) {
            return DwcTerm.family;
        }
        if (rank == GENUS) {
            return DwcTerm.genus;
        }
        if (rank == SUBGENUS) {
            return DwcTerm.subgenus;
        }
        return null;
    }

    @Deprecated
    public static Rank valueOf(int termID) {
        return Rank.valueOfTermID(termID);
    }

    public static Rank valueOfTermID(Integer termID) {
        for (Rank term : Rank.values()) {
            if (termID == null || term.termID() != termID.intValue()) continue;
            return term;
        }
        return null;
    }

    public boolean isSpeciesOrBelow() {
        return SPECIES_OR_BELOW.contains(this);
    }

    public boolean isInfraspecific() {
        return SPECIES_OR_BELOW.contains(this) && this != SPECIES && this != CultivarGroup && this != Cultivar && this != Strain;
    }

    public boolean isSuprageneric() {
        return SUPRAGENERIC.contains(this);
    }

    public boolean isLinnean() {
        for (Rank r : LINNEAN_RANKS) {
            if (r != this) continue;
            return true;
        }
        return false;
    }

    public boolean isUncomparable() {
        return UNCOMPARABLE_RANKS.contains(this);
    }

    @Override
    public int termID() {
        return 0 + this.id;
    }

    @Override
    public TermType type() {
        return TermType.RANK;
    }

    static {
        KINGDOM_TO_SUBGENUS = new Rank[]{KINGDOM, PHYLUM, CLASS, ORDER, FAMILY, GENUS, SUBGENUS};
        LINNEAN_RANKS = new Rank[]{KINGDOM, PHYLUM, CLASS, ORDER, FAMILY, GENUS, SPECIES};
        HashSet<Rank> mayorRanks = new HashSet<Rank>();
        mayorRanks.add(KINGDOM);
        mayorRanks.add(PHYLUM);
        mayorRanks.add(CLASS);
        mayorRanks.add(ORDER);
        mayorRanks.add(FAMILY);
        mayorRanks.add(GENUS);
        mayorRanks.add(SUBGENUS);
        mayorRanks.add(SPECIES);
        MAYOR_RANKS = ImmutableSet.copyOf(mayorRanks);
        Cloneable ranks = new HashSet<Rank>();
        ranks.add(InfragenericName);
        ranks.add(InfraspecificName);
        ranks.add(InfrasubspecificName);
        ranks.add(Informal);
        ranks.add(Unranked);
        UNCOMPARABLE_RANKS = ImmutableSet.copyOf(ranks);
        ranks = new HashSet();
        ranks.add(SPECIES);
        ranks.add(InfraspecificName);
        ranks.add(SUBSPECIES);
        ranks.add(InfrasubspecificName);
        ranks.add(VARIETY);
        ranks.add(Subvariety);
        ranks.add(Form);
        ranks.add(Subform);
        ranks.add(CultivarGroup);
        ranks.add(Cultivar);
        ranks.add(Strain);
        SPECIES_OR_BELOW = ranks;
        ranks = new HashSet();
        ranks.add((Rank)Domain);
        ranks.add((Rank)KINGDOM);
        ranks.add((Rank)Subkingdom);
        ranks.add((Rank)Superphylum);
        ranks.add((Rank)PHYLUM);
        ranks.add((Rank)Subphylum);
        ranks.add((Rank)Superclass);
        ranks.add((Rank)CLASS);
        ranks.add((Rank)Subclass);
        ranks.add((Rank)Superorder);
        ranks.add((Rank)ORDER);
        ranks.add((Rank)Suborder);
        ranks.add((Rank)Infraorder);
        ranks.add((Rank)Superfamily);
        ranks.add((Rank)FAMILY);
        ranks.add((Rank)Subfamily);
        ranks.add((Rank)Tribe);
        ranks.add((Rank)Subtribe);
        ranks.add((Rank)SupragenericName);
        SUPRAGENERIC = ImmutableSet.copyOf(ranks);
        ranks = new HashMap();
        ((HashMap)ranks).put("fam", FAMILY);
        ((HashMap)ranks).put("trib", Tribe);
        ((HashMap)ranks).put("sect", Section);
        ((HashMap)ranks).put("supertrib", SupragenericName);
        ((HashMap)ranks).put("supersubtrib", SupragenericName);
        ((HashMap)ranks).put("ib", SupragenericName);
        ((HashMap)ranks).put("gen", GENUS);
        RANK_MARKER_MAP_SUPRAGENERIC = ImmutableMap.copyOf((Map)((Object)ranks));
        ranks = new HashMap();
        ((HashMap)ranks).put("subgenus", SUBGENUS);
        ((HashMap)ranks).put("subgen", SUBGENUS);
        ((HashMap)ranks).put("subg", SUBGENUS);
        ((HashMap)ranks).put("section", Section);
        ((HashMap)ranks).put("sect", Section);
        ((HashMap)ranks).put("subsection", Subsection);
        ((HashMap)ranks).put("subsect", Subsection);
        ((HashMap)ranks).put("series", Series);
        ((HashMap)ranks).put("ser", Series);
        ((HashMap)ranks).put("subseries", Subseries);
        ((HashMap)ranks).put("subser", Subseries);
        ((HashMap)ranks).put("agg", InfragenericName);
        ((HashMap)ranks).put("species", SPECIES);
        ((HashMap)ranks).put("spec", SPECIES);
        ((HashMap)ranks).put("spp", SPECIES);
        ((HashMap)ranks).put("sp", SPECIES);
        RANK_MARKER_MAP_INFRAGENERIC = ImmutableMap.copyOf((Map)((Object)ranks));
        ranks = new HashMap();
        ((HashMap)ranks).put("subsp", SUBSPECIES);
        ((HashMap)ranks).put("ssp", SUBSPECIES);
        ((HashMap)ranks).put("var", VARIETY);
        ((HashMap)ranks).put("v", VARIETY);
        ((HashMap)ranks).put("subvar", Subvariety);
        ((HashMap)ranks).put("subv", Subvariety);
        ((HashMap)ranks).put("sv", Subvariety);
        ((HashMap)ranks).put("forma", Form);
        ((HashMap)ranks).put("form", Form);
        ((HashMap)ranks).put("fo", Form);
        ((HashMap)ranks).put("f", Form);
        ((HashMap)ranks).put("subform", Subform);
        ((HashMap)ranks).put("subf", Subform);
        ((HashMap)ranks).put("sf", Subform);
        ((HashMap)ranks).put("cv", Cultivar);
        ((HashMap)ranks).put("hort", Cultivar);
        ((HashMap)ranks).put("m", InfrasubspecificName);
        ((HashMap)ranks).put("morph", InfrasubspecificName);
        ((HashMap)ranks).put("nat", InfrasubspecificName);
        ((HashMap)ranks).put("ab", InfrasubspecificName);
        ((HashMap)ranks).put("aberration", InfrasubspecificName);
        ((HashMap)ranks).put("\\*+", InfraspecificName);
        RANK_MARKER_MAP_INFRASPECIFIC = ImmutableMap.copyOf((Map)((Object)ranks));
        ranks = new HashMap();
        ((HashMap)ranks).putAll(RANK_MARKER_MAP_SUPRAGENERIC);
        ((HashMap)ranks).putAll(RANK_MARKER_MAP_INFRAGENERIC);
        ((HashMap)ranks).putAll(RANK_MARKER_MAP_INFRASPECIFIC);
        ((HashMap)ranks).put("subser", Subseries);
        RANK_MARKER_MAP = ImmutableMap.copyOf((Map)((Object)ranks));
        ranks = new TreeMap(new StringLengthComparator());
        ranks.put("mycetidae", Subclass);
        ranks.put("phycidae", Subclass);
        ranks.put("mycotina", Subphylum);
        ranks.put("phytina", Subphylum);
        ranks.put("phyceae", CLASS);
        ranks.put("mycetes", CLASS);
        ranks.put("mycota", PHYLUM);
        ranks.put("opsida", CLASS);
        ranks.put("oideae", Subfamily);
        ranks.put("aceae", FAMILY);
        ranks.put("phyta", PHYLUM);
        ranks.put("oidea", Superfamily);
        ranks.put("anae", Superorder);
        ranks.put("ales", ORDER);
        ranks.put("acea", Superfamily);
        ranks.put("idae", FAMILY);
        ranks.put("inae", Subfamily);
        ranks.put("eae", Tribe);
        ranks.put("ini", Tribe);
        SUFFICES_RANK_MAP = ranks;
    }
}

