/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.voc;

public enum NameType {
    sciname,
    wellformed,
    doubtful,
    blacklisted,
    virus,
    hybrid,
    informal,
    cultivar;


    public static NameType fromString(String x) {
        if (x == null) {
            return null;
        }
        if ((x = x.toLowerCase().trim()).length() == 0) {
            return null;
        }
        for (NameType term : NameType.values()) {
            if (term.toString().toLowerCase().equals(x)) {
                return term;
            }
            if (term.toString().toLowerCase().charAt(0) != x.charAt(0)) continue;
            return term;
        }
        return null;
    }

    public static NameType valueOf(Integer id) {
        if (id == null) {
            return null;
        }
        for (NameType term : NameType.values()) {
            if (term.ordinal() != id.intValue()) continue;
            return term;
        }
        return null;
    }

    public boolean isBetterThan(NameType other) {
        if (other == null) {
            return true;
        }
        if (blacklisted != this) {
            if (informal == this && blacklisted == other) {
                return true;
            }
            if (doubtful == this && (blacklisted == other || informal == other)) {
                return true;
            }
            if (!(sciname != this && virus != this && hybrid != this || blacklisted != other && informal != other && doubtful != other)) {
                return true;
            }
            if (wellformed == this && wellformed != other) {
                return true;
            }
        }
        return false;
    }

    public boolean isParsable() {
        return hybrid != this && virus != this && blacklisted != this;
    }
}

